/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JExpression;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Collection;
import java.util.Iterator;
import org.jpmml.translator.PrimitiveRef;
import org.jpmml.translator.TranslationContext;

public class FpPrimitiveRef
extends PrimitiveRef {
    public FpPrimitiveRef(JExpression expression) {
        super(expression);
        if (expression instanceof JVar) {
            JVar variable = (JVar)expression;
            JType type = variable.type();
            switch (type.name()) {
                case "float": 
                case "double": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(type.fullName());
                }
            }
        }
    }

    @Override
    public JExpression isMissing() {
        JExpression expression = this.getExpression();
        return expression.ne(expression);
    }

    @Override
    public JExpression isNotMissing() {
        JExpression expression = this.getExpression();
        return expression.eq(expression);
    }

    @Override
    public JExpression notEqualTo(Object value, TranslationContext context) {
        return this.isNotMissing().cand(super.notEqualTo(value, context));
    }

    @Override
    public JExpression isNotIn(Collection<?> values, TranslationContext context) {
        Iterator it = values.stream().sorted().iterator();
        JExpression result = super.notEqualTo(it.next(), context);
        while (it.hasNext()) {
            result = result.cand(super.notEqualTo(it.next(), context));
        }
        return this.isNotMissing().cand(result);
    }
}

