/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.google.common.math.DoubleMath;
import com.sun.codemodel.JExpression;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.translator.ObjectRef;
import org.jpmml.translator.TranslationContext;

public class NumberRef
extends ObjectRef {
    public NumberRef(JExpression expression) {
        super(expression);
    }

    @Override
    public JExpression equalTo(Object value, TranslationContext context) {
        JExpression expression = this.getExpression();
        return expression.eq(this.literal(value, context));
    }

    @Override
    public JExpression notEqualTo(Object value, TranslationContext context) {
        JExpression expression = this.getExpression();
        return expression.ne(this.literal(value, context));
    }

    @Override
    public JExpression lessThan(Object value, TranslationContext context) {
        JExpression expression = this.getExpression();
        return expression.lt(this.literal(value, context));
    }

    @Override
    public JExpression lessOrEqual(Object value, TranslationContext context) {
        JExpression expression = this.getExpression();
        return expression.lte(this.literal(value, context));
    }

    @Override
    public JExpression greaterOrEqual(Object value, TranslationContext context) {
        JExpression expression = this.getExpression();
        return expression.gte(this.literal(value, context));
    }

    @Override
    public JExpression greaterThan(Object value, TranslationContext context) {
        JExpression expression = this.getExpression();
        return expression.gt(this.literal(value, context));
    }

    @Override
    public JExpression literal(Object value, TranslationContext context) {
        JExpression expression = this.getExpression();
        if (value instanceof String) {
            String string = (String)value;
            try {
                value = TypeUtil.parseOrCast((DataType)DataType.DOUBLE, (Object)string);
                if (DoubleMath.isMathematicalInteger((double)((Double)value))) {
                    value = TypeUtil.parseOrCast((DataType)DataType.INTEGER, (Object)value);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return super.literal(value, context);
    }
}

