/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator.mining;

import com.google.common.collect.Iterables;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLElements;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.True;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.regression.NumericPredictor;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.jpmml.evaluator.Classification;
import org.jpmml.model.InvalidElementException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.UnsupportedAttributeException;
import org.jpmml.model.UnsupportedElementException;
import org.jpmml.model.XPathUtil;
import org.jpmml.translator.IdentifierUtil;
import org.jpmml.translator.MethodScope;
import org.jpmml.translator.ModelTranslator;
import org.jpmml.translator.PMMLObjectUtil;
import org.jpmml.translator.TranslationContext;
import org.jpmml.translator.ValueFactoryRef;
import org.jpmml.translator.ValueMapBuilder;
import org.jpmml.translator.mining.MiningModelTranslator;
import org.jpmml.translator.regression.RegressionModelTranslator;

public class ModelChainTranslator
extends MiningModelTranslator {
    public ModelChainTranslator(PMML pmml, MiningModel miningModel) {
        super(pmml, miningModel);
        MiningFunction miningFunction = miningModel.requireMiningFunction();
        switch (miningFunction) {
            case CLASSIFICATION: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)miningModel, (Enum)miningFunction);
            }
        }
        MathContext mathContext = miningModel.getMathContext();
        Segmentation segmentation = miningModel.requireSegmentation();
        Segmentation.MultipleModelMethod multipleModelMethod = segmentation.requireMultipleModelMethod();
        switch (multipleModelMethod) {
            case MODEL_CHAIN: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)segmentation, (Enum)multipleModelMethod);
            }
        }
        List segments = segmentation.requireSegments();
        List regressorSegments = segments.subList(0, segments.size() - 1);
        for (Segment regressorSegment : regressorSegments) {
            Object outputFields;
            True _true = (True)regressorSegment.requirePredicate(True.class);
            Model model = regressorSegment.requireModel();
            MiningFunction modelMiningFunction = model.requireMiningFunction();
            switch (modelMiningFunction) {
                case REGRESSION: {
                    break;
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)model, (Enum)modelMiningFunction);
                }
            }
            MathContext modelMathContext = model.getMathContext();
            if (!Objects.equals(mathContext, modelMathContext)) {
                throw new UnsupportedAttributeException((PMMLObject)model, (Enum)modelMathContext);
            }
            ModelChainTranslator.checkMiningSchema(model);
            Output modelOutput = model.getOutput();
            if (modelOutput == null) {
                throw new MissingElementException(MissingElementException.formatMessage((String)(XPathUtil.formatElement(model.getClass()) + "/" + XPathUtil.formatElement(Output.class))), (PMMLObject)model);
            }
            if (modelOutput.hasOutputFields()) {
                outputFields = modelOutput.getOutputFields();
                if (outputFields.size() != 1) {
                    throw new UnsupportedElementException((PMMLObject)modelOutput);
                }
                OutputField outputField = (OutputField)Iterables.getOnlyElement((Iterable)outputFields);
                ResultFeature resultFeature = outputField.getResultFeature();
                switch (resultFeature) {
                    case PREDICTED_VALUE: {
                        break;
                    }
                    default: {
                        throw new UnsupportedAttributeException((PMMLObject)outputField, (Enum)resultFeature);
                    }
                }
            } else {
                throw new MissingElementException((PMMLObject)modelOutput, PMMLElements.OUTPUT_OUTPUTFIELDS);
            }
            outputFields = this.newModelTranslator(model);
        }
        Segment classifierSegment = (Segment)segments.get(segments.size() - 1);
        True _true = (True)classifierSegment.requirePredicate(True.class);
        RegressionModel regressionModel = (RegressionModel)classifierSegment.requireModel(RegressionModel.class);
        MiningFunction modelMiningFunction = regressionModel.requireMiningFunction();
        switch (modelMiningFunction) {
            case CLASSIFICATION: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)regressionModel, (Enum)modelMiningFunction);
            }
        }
        MathContext modelMathContext = regressionModel.getMathContext();
        if (!Objects.equals(mathContext, modelMathContext)) {
            throw new UnsupportedAttributeException((PMMLObject)regressionModel, (Enum)modelMathContext);
        }
        ModelChainTranslator.checkMiningSchema((Model)regressionModel);
        ModelChainTranslator.checkLocalTransformations((Model)regressionModel);
        ModelChainTranslator.checkTargets((Model)regressionModel);
        List regressionTables = regressionModel.getRegressionTables();
        for (RegressionTable regressionTable : regressionTables) {
            List numericPredictors;
            if (regressionTable.hasNumericPredictors() && (numericPredictors = regressionTable.getNumericPredictors()).size() > 1) {
                throw new InvalidElementException((PMMLObject)regressionTable);
            }
            if (!regressionTable.hasCategoricalPredictors() && !regressionTable.hasPredictorTerms()) continue;
            throw new UnsupportedElementException((PMMLObject)regressionTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMethod translateClassifier(TranslationContext context) {
        MiningModel miningModel = (MiningModel)this.getModel();
        Segmentation segmentation = miningModel.requireSegmentation();
        JMethod evaluateMethod = ModelChainTranslator.createEvaluatorMethod(Classification.class, (PMMLObject)segmentation, true, context);
        try {
            context.pushScope(new MethodScope(evaluateMethod));
            this.translateSegmentation(segmentation, context);
        }
        finally {
            context.popScope();
        }
        return evaluateMethod;
    }

    private void translateSegmentation(Segmentation segmentation, TranslationContext context) {
        MiningModel miningModel = (MiningModel)this.getModel();
        List segments = segmentation.requireSegments();
        List regressorSegments = segments.subList(0, segments.size() - 1);
        for (Segment regressorSegment : regressorSegments) {
            Model model = regressorSegment.requireModel();
            Output modelOutput = model.getOutput();
            OutputField outputField = (OutputField)Iterables.getOnlyElement((Iterable)modelOutput.getOutputFields());
            ModelTranslator<?> modelTranslator = this.newModelTranslator(model);
            JMethod evaluateMethod = modelTranslator.translateRegressor(context);
            JInvocation methodInvocation = ModelChainTranslator.createEvaluatorMethodInvocation(evaluateMethod, context);
            context.declare((JType)context.getValueType(), IdentifierUtil.create("value", outputField.requireName()), (JExpression)methodInvocation);
            ModelChainTranslator.pullUpDerivedFields(miningModel, model);
        }
        ValueMapBuilder valueMapBuilder = new ValueMapBuilder(context).construct("values");
        Segment classifierSegment = (Segment)segments.get(segments.size() - 1);
        RegressionModel regressionModel = (RegressionModel)classifierSegment.requireModel(RegressionModel.class);
        List regressionTables = regressionModel.getRegressionTables();
        for (RegressionTable regressionTable : regressionTables) {
            JVar valueExpr;
            List numericPredictors = regressionTable.getNumericPredictors();
            Number intercept = regressionTable.requireIntercept();
            NumericPredictor numericPredictor = (NumericPredictor)Iterables.getFirst((Iterable)numericPredictors, null);
            if (numericPredictor != null) {
                valueExpr = context.getVariable(IdentifierUtil.create("value", numericPredictor.requireField()));
                Number coefficient = numericPredictor.requireCoefficient();
                if (coefficient.doubleValue() != 1.0) {
                    valueExpr = context.invoke((JExpression)valueExpr, "multiply", coefficient);
                }
                if (intercept.doubleValue() != 0.0) {
                    valueExpr = context.invoke((JExpression)valueExpr, "add", intercept);
                }
            } else {
                ValueFactoryRef valueFactoryRef = context.getValueFactoryVariable();
                valueExpr = intercept.doubleValue() != 0.0 ? valueFactoryRef.newValue(PMMLObjectUtil.createExpression(intercept, context)) : valueFactoryRef.newValue();
            }
            valueMapBuilder.update("put", regressionTable.getTargetCategory(), valueExpr);
        }
        RegressionModelTranslator.computeClassification(valueMapBuilder, regressionModel, context);
        ModelChainTranslator.pullUpOutputFields(miningModel, (Model)regressionModel);
    }
}

