/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.Field;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.java.JavaModel;
import org.jpmml.translator.Encoder;
import org.jpmml.translator.FieldInfo;
import org.jpmml.translator.FieldValueRef;
import org.jpmml.translator.IdentifierUtil;
import org.jpmml.translator.MethodScope;
import org.jpmml.translator.OrdinalRef;
import org.jpmml.translator.TranslationContext;

public class OrdinalEncoder
implements Encoder {
    private Map<Object, Integer> indexMap = new LinkedHashMap<Object, Integer>();
    private JMethod isSetMethod = null;
    public static final JExpression INIT_VALUE = JExpr.lit((int)-999);
    public static final JExpression MISSING_VALUE = JExpr.lit((int)-1);

    public OrdinalEncoder(Set<?> values) {
        int index = 1;
        for (Object value : values) {
            this.indexMap.put(value, index);
            ++index;
        }
    }

    @Override
    public String getVariableName(FieldInfo fieldInfo) {
        Field<?> field = fieldInfo.getField();
        return IdentifierUtil.sanitize(field.requireName()) + "2ordinal";
    }

    @Override
    public Integer encode(Object value) {
        return this.indexMap.getOrDefault(value, 0);
    }

    @Override
    public OrdinalRef ref(JExpression expression) {
        return new OrdinalRef(expression, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMethod createEncoderMethod(FieldInfo fieldInfo, TranslationContext context) {
        JDefinedClass owner = context.getOwner();
        Field<?> field = fieldInfo.getField();
        JMethod method = owner.method(12, Integer.TYPE, IdentifierUtil.create("toOrdinal", field.requireName()));
        JVar nameParam = method.param(String.class, "name");
        try {
            context.pushScope(new MethodScope(method));
            JVar valueVar = context.declare(FieldValue.class, "value", (JExpression)context.invoke((JExpression)JExpr.refthis((String)"context"), "evaluate", nameParam));
            FieldValueRef fieldValueRef = new FieldValueRef(valueVar, field.requireDataType());
            context._returnIf(valueVar.eq(JExpr._null()), MISSING_VALUE);
            JVar javaValueVar = context.declare(fieldValueRef.getJavaType(), "javaValue", (JExpression)fieldValueRef.asJavaValue());
            context._return((JExpression)javaValueVar, this.indexMap, 0);
        }
        finally {
            context.popScope();
        }
        return method;
    }

    @Override
    public JExpression createInitExpression(FieldInfo fieldInfo, TranslationContext context) {
        return INIT_VALUE;
    }

    public JMethod ensureIsSetMethod(TranslationContext context) {
        if (this.isSetMethod == null) {
            this.isSetMethod = this.getOrCreateIsSetMethod(context);
        }
        return this.isSetMethod;
    }

    private JMethod getOrCreateIsSetMethod(TranslationContext context) {
        JDefinedClass owner = context.getOwner(JavaModel.class);
        JType intType = context._ref(Integer.TYPE);
        JMethod isSetMethod = owner.getMethod("isSet", new JType[]{intType, intType});
        if (isSetMethod != null) {
            return isSetMethod;
        }
        isSetMethod = owner.method(28, Boolean.TYPE, "isSet");
        JVar bitSetParam = isSetMethod.param(intType, "bitSet");
        JVar indexParam = isSetMethod.param(intType, "index");
        JBlock block = isSetMethod.body();
        JBlock thenBlock = block._if(indexParam.gte(JExpr.lit((int)0)).cand(indexParam.lte(JExpr.lit((int)31))))._then();
        JVar maskVar = thenBlock.decl(intType, "mask", JExpr.lit((int)1).shl((JExpression)indexParam));
        thenBlock._return(bitSetParam.band((JExpression)maskVar).eq((JExpression)maskVar));
        block._return(JExpr.FALSE);
        return isSetMethod;
    }

    public static OrdinalEncoder create(FieldInfo fieldInfo, Set<?> values) {
        return new OrdinalEncoder(values);
    }
}

