/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.dmg.pmml.DataType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TextIndex;
import org.jpmml.evaluator.TokenizedString;
import org.jpmml.translator.ArrayEncoder;
import org.jpmml.translator.FieldInfo;
import org.jpmml.translator.FpPrimitiveEncoder;
import org.jpmml.translator.FunctionInvocation;
import org.jpmml.translator.IdentifierUtil;
import org.jpmml.translator.MethodScope;
import org.jpmml.translator.Scope;
import org.jpmml.translator.TextIndexUtil;
import org.jpmml.translator.TranslationContext;

public class TermFrequencyEncoder
extends FpPrimitiveEncoder
implements ArrayEncoder {
    private int index = -1;
    private List<TokenizedString> vocabulary = null;

    @Override
    public String getVariableName(FieldInfo fieldInfo) {
        FunctionInvocation.Tf tf = this.getTf(fieldInfo);
        return IdentifierUtil.sanitize(tf.getTextField()) + "2tf$" + String.valueOf(this.getIndex());
    }

    @Override
    public String getMemberName(FieldInfo fieldInfo) {
        FunctionInvocation.Tf tf = this.getTf(fieldInfo);
        return IdentifierUtil.sanitize(tf.getTextField()) + "2tf";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMethod createEncoderMethod(FieldInfo fieldInfo, JPrimitiveType returnType, String name, List<JPrimitiveType> castSequenceTypes, DataType dataType, TranslationContext context) {
        JDefinedClass owner = context.getOwner();
        FunctionInvocation.Tf tf = this.getTf(fieldInfo);
        name = IdentifierUtil.create(name, tf.getTextField());
        JMethod method = owner.getMethod(name, new JType[]{context._ref(Integer.TYPE)});
        if (method != null) {
            return method;
        }
        JDefinedClass ownerOwner = (JDefinedClass)owner.parentContainer();
        Map fields = ownerOwner.fields();
        JFieldVar textIndexVar = (JFieldVar)fields.get(IdentifierUtil.create("textIndex", (PMMLObject)tf.getTextIndex(), tf.getTextField()));
        JFieldVar termsVar = (JFieldVar)fields.get(IdentifierUtil.create("terms", (PMMLObject)tf.getTextIndex(), tf.getTextField()));
        JFieldVar termFrequencyTableVar = owner.field(4, (JType)context.genericRef(Map.class, TokenizedString.class, Integer.class), IdentifierUtil.create("termFrequencyTable", tf.getTextField()));
        JMethod frequencyTableMethod = owner.method(12, termFrequencyTableVar.type(), termFrequencyTableVar.name());
        try {
            context.pushScope(new MethodScope(frequencyTableMethod));
            JBlock block = frequencyTableMethod.body();
            JBlock thenBlock = block._if(termFrequencyTableVar.eq(JExpr._null()))._then();
            try {
                context.pushScope(new Scope(thenBlock));
                TextIndex localTextIndex = TextIndexUtil.toLocalTextIndex(tf.getTextIndex(), tf.getTextField());
                int maxLength = this.getVocabulary().stream().mapToInt(TokenizedString::size).max().orElseThrow(NoSuchElementException::new);
                TextIndexUtil.computeTermFrequencyTable((JVar)termFrequencyTableVar, localTextIndex, (JExpression)textIndexVar, (JExpression)context._new(HashSet.class, termsVar), maxLength, context);
            }
            finally {
                context.popScope();
            }
            block._return((JExpression)termFrequencyTableVar);
        }
        finally {
            context.popScope();
        }
        method = owner.method(12, (JType)returnType, name);
        JVar indexParam = method.param(context._ref(Integer.TYPE), "index");
        try {
            JInvocation javaValueExpr;
            context.pushScope(new MethodScope(method));
            JVar frequencyVar = context.declare(Integer.class, "frequency", (JExpression)JExpr.invoke((JMethod)frequencyTableMethod).invoke("get").arg((JExpression)termsVar.invoke("get").arg((JExpression)indexParam)));
            JExpression nanExpr = JExpr.lit((int)0);
            switch (dataType) {
                case INTEGER: {
                    javaValueExpr = frequencyVar.invoke("intValue");
                    break;
                }
                case FLOAT: {
                    javaValueExpr = frequencyVar.invoke("floatValue");
                    break;
                }
                case DOUBLE: {
                    javaValueExpr = frequencyVar.invoke("doubleValue");
                    break;
                }
                default: {
                    throw new IllegalArgumentException(dataType.toString());
                }
            }
            javaValueExpr = TermFrequencyEncoder.fpJavaValue((JExpression)javaValueExpr, returnType, castSequenceTypes, context);
            context._return(frequencyVar.eq(JExpr._null()), nanExpr, (JExpression)javaValueExpr);
        }
        finally {
            context.popScope();
        }
        return method;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public TermFrequencyEncoder setIndex(int index) {
        this.index = index;
        return this;
    }

    @Override
    public int getLength() {
        List<TokenizedString> vocabulary = this.getVocabulary();
        if (vocabulary == null) {
            throw new IllegalStateException();
        }
        return vocabulary.size();
    }

    public List<TokenizedString> getVocabulary() {
        return this.vocabulary;
    }

    public TermFrequencyEncoder setVocabulary(List<TokenizedString> vocabulary) {
        this.vocabulary = vocabulary;
        return this;
    }

    public FunctionInvocation.Tf getTf(FieldInfo fieldInfo) {
        FieldInfo finalFieldInfo = this.follow(fieldInfo);
        return (FunctionInvocation.Tf)finalFieldInfo.getFunctionInvocation();
    }
}

