/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.google.common.collect.Iterables;
import com.sun.codemodel.JInvocation;
import jakarta.xml.bind.annotation.XmlTransient;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.RichComplexArray;
import org.jpmml.evaluator.java.JavaModel;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;
import org.jpmml.translator.JavaModelTemplate;
import org.jpmml.translator.ModelTemplate;
import org.jpmml.translator.PMMLObjectUtil;
import org.jpmml.translator.PMMLTemplate;
import org.jpmml.translator.RichComplexArrayTemplate;
import org.jpmml.translator.TranslationContext;

public class Template {
    private Set<Field> suppressedValueConstructorFields = null;
    private List<Field> instanceFields = Collections.emptyList();
    private List<Field> valueConstructorFields = Collections.emptyList();
    private List<Field> setterMethodFields = Collections.emptyList();
    private static final Map<Class<? extends PMMLObject>, Template> templates = new HashMap<Class<? extends PMMLObject>, Template>();

    Template(Class<? extends PMMLObject> clazz) {
        this(clazz, ReflectionUtil.getFields(clazz));
    }

    Template(Class<? extends PMMLObject> clazz, List<Field> instanceFields) {
        this(clazz, instanceFields, Collections.emptySet());
    }

    Template(Class<? extends PMMLObject> clazz, List<Field> instanceFields, Set<Field> suppressedValueConstructorFields) {
        this.suppressedValueConstructorFields = Objects.requireNonNull(suppressedValueConstructorFields);
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        for (Field instanceField : instanceFields) {
            boolean xmlTransient;
            boolean bl = xmlTransient = instanceField.getAnnotation(XmlTransient.class) != null;
            if (xmlTransient) continue;
            fields.put(instanceField.getName(), instanceField);
        }
        this.instanceFields = new ArrayList(fields.values());
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        List valueConstructors = Arrays.stream(constructors).filter(constructor -> constructor.getAnnotation(ValueConstructor.class) != null).collect(Collectors.toList());
        if (!valueConstructors.isEmpty()) {
            this.valueConstructorFields = new ArrayList<Field>();
            Constructor valueConstructor = (Constructor)Iterables.getOnlyElement(valueConstructors);
            Annotation[][] parameterAnnotations = valueConstructor.getParameterAnnotations();
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                Property property = (Property)parameterAnnotations[i][0];
                Field valueConstructorField = (Field)fields.get(property.value());
                if (!this.suppressedValueConstructorFields.contains(valueConstructorField)) {
                    fields.remove(property.value());
                }
                this.valueConstructorFields.add(valueConstructorField);
            }
        } else {
            this.valueConstructorFields = new ArrayList<Field>();
        }
        this.setterMethodFields = new ArrayList(fields.values());
    }

    public JInvocation constructObject(PMMLObject object, JInvocation invocation, TranslationContext context) {
        List<Field> valueConstructorFields = this.getValueConstructorFields();
        for (Field valueConstructorField : valueConstructorFields) {
            Object value = !this.suppressedValueConstructorFields.contains(valueConstructorField) ? ReflectionUtil.getFieldValue((Field)valueConstructorField, (Object)object) : null;
            PMMLObjectUtil.addValueConstructorParam(valueConstructorField, value, invocation, context);
        }
        return invocation;
    }

    public JInvocation initializeObject(PMMLObject object, JInvocation invocation, TranslationContext context) {
        List<Field> setterMethodFields = this.getSetterMethodFields();
        for (Field setterMethodField : setterMethodFields) {
            Object value = ReflectionUtil.getFieldValue((Field)setterMethodField, (Object)object);
            invocation = PMMLObjectUtil.addSetterMethod(setterMethodField, value, invocation, context);
        }
        return invocation;
    }

    public Field getInstanceField(String name) {
        List<Field> instanceFields = this.getInstanceFields();
        for (Field instanceField : instanceFields) {
            if (!name.equals(instanceField.getName())) continue;
            return instanceField;
        }
        return null;
    }

    public List<Field> getInstanceFields() {
        return this.instanceFields;
    }

    public List<Field> getValueConstructorFields() {
        return this.valueConstructorFields;
    }

    public List<Field> getSetterMethodFields() {
        return this.setterMethodFields;
    }

    public static Template getTemplate(Class<? extends PMMLObject> clazz) {
        Template template = templates.get(clazz);
        if (template == null) {
            template = PMML.class.isAssignableFrom(clazz) ? new PMMLTemplate((Class<? extends PMML>)clazz.asSubclass(PMML.class)) : (JavaModel.class.isAssignableFrom(clazz) ? new JavaModelTemplate() : (Model.class.isAssignableFrom(clazz) ? new ModelTemplate((Class<? extends Model>)clazz.asSubclass(Model.class)) : (RichComplexArray.class.isAssignableFrom(clazz) ? new RichComplexArrayTemplate((Class<? extends RichComplexArray>)clazz.asSubclass(RichComplexArray.class)) : new Template(clazz))));
            templates.put(clazz, template);
        }
        return template;
    }
}

