/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.MissingFieldValueException;
import org.jpmml.translator.ArrayEncoder;
import org.jpmml.translator.ArrayInfo;
import org.jpmml.translator.FieldInfo;
import org.jpmml.translator.FpPrimitiveEncoder;
import org.jpmml.translator.IdentifierUtil;
import org.jpmml.translator.MethodScope;
import org.jpmml.translator.TranslationContext;

public class ArrayFpPrimitiveEncoder
extends FpPrimitiveEncoder
implements ArrayEncoder {
    private ArrayInfo arrayInfo = null;
    private int index = -1;
    private List<DataField> elements = null;

    public ArrayFpPrimitiveEncoder(ArrayInfo arrayInfo) {
        this.setArrayInfo(arrayInfo);
    }

    @Override
    public String getVariableName(FieldInfo fieldInfo) {
        ArrayInfo arrayInfo = this.getArrayInfo();
        return IdentifierUtil.sanitize(arrayInfo.getName()) + "2fp$" + String.valueOf(this.getIndex());
    }

    @Override
    public String getMemberName(FieldInfo fieldInfo) {
        ArrayInfo arrayInfo = this.getArrayInfo();
        return IdentifierUtil.sanitize(arrayInfo.getName()) + "2fp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMethod createEncoderMethod(FieldInfo fieldInfo, JPrimitiveType returnType, String name, List<JPrimitiveType> castSequenceTypes, DataType dataType, TranslationContext context) {
        JDefinedClass owner = context.getOwner();
        ArrayInfo arrayInfo = this.getArrayInfo();
        name = (String)name + "$" + IdentifierUtil.sanitize(arrayInfo.getName());
        JMethod method = owner.getMethod((String)name, new JType[]{context._ref(Integer.TYPE)});
        if (method != null) {
            return method;
        }
        JFieldVar listField = owner.field(4, (JType)context.genericRef(List.class, Number.class), IdentifierUtil.sanitize(arrayInfo.getName()));
        JMethod ensureListMethod = owner.method(12, listField.type(), IdentifierUtil.sanitize(arrayInfo.getName()));
        try {
            context.pushScope(new MethodScope(ensureListMethod));
            JExpression nameExpr = context.constantFieldName(arrayInfo.getName(), true);
            JBlock block = ensureListMethod.body();
            JBlock thenBlock = block._if(JExpr.refthis((String)listField.name()).eq(JExpr._null()))._then();
            JVar valueVar = thenBlock.decl((JType)context.ref(FieldValue.class), "value", (JExpression)context.invoke((JExpression)JExpr.refthis((String)"context"), "evaluate", nameExpr));
            thenBlock._if(valueVar.eq(JExpr._null()))._then()._throw((JExpression)context._new(MissingFieldValueException.class, nameExpr));
            thenBlock.assign((JAssignmentTarget)JExpr.refthis((String)listField.name()), (JExpression)JExpr.cast((JType)listField.type(), (JExpression)valueVar.invoke("getValue")));
            block._return((JExpression)JExpr.refthis((String)listField.name()));
        }
        finally {
            context.popScope();
        }
        method = owner.method(12, (JType)returnType, (String)name);
        JVar indexParam = method.param(context._ref(Integer.TYPE), "index");
        try {
            JInvocation invocation;
            context.pushScope(new MethodScope(method));
            JVar listVar = context.declare(ensureListMethod.type(), listField.name(), (JExpression)JExpr.invoke((JMethod)ensureListMethod));
            JVar numberVar = context.declare(Number.class, "number", (JExpression)listVar.invoke("get").arg((JExpression)indexParam));
            switch (dataType) {
                case FLOAT: {
                    invocation = numberVar.invoke("floatValue");
                    break;
                }
                case DOUBLE: {
                    invocation = numberVar.invoke("doubleValue");
                    break;
                }
                default: {
                    throw new IllegalArgumentException(dataType.toString());
                }
            }
            JExpression nanExpr = ArrayFpPrimitiveEncoder.fpNanValue(returnType, context);
            JExpression javaValueExpr = ArrayFpPrimitiveEncoder.fpJavaValue((JExpression)invocation, returnType, castSequenceTypes, context);
            context._return(numberVar.eq(JExpr._null()), nanExpr, javaValueExpr);
        }
        finally {
            context.popScope();
        }
        return method;
    }

    public ArrayInfo getArrayInfo() {
        return this.arrayInfo;
    }

    private void setArrayInfo(ArrayInfo arrayInfo) {
        this.arrayInfo = Objects.requireNonNull(arrayInfo);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public ArrayFpPrimitiveEncoder setIndex(int index) {
        this.index = index;
        return this;
    }

    @Override
    public int getLength() {
        List<DataField> elements = this.getElements();
        if (elements == null) {
            throw new IllegalStateException();
        }
        return elements.size();
    }

    public List<DataField> getElements() {
        return this.elements;
    }

    public ArrayFpPrimitiveEncoder setElements(List<DataField> elements) {
        this.elements = elements;
        return this;
    }
}

