/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;

public class ArrayInfo {
    private String name = null;
    private BiMap<Integer, DataField> dataFields = HashBiMap.create();

    public ArrayInfo(String name) {
        this.setName(name);
    }

    public int getIndex(DataField dataField) {
        BiMap<Integer, DataField> dataFields = this.getDataFields();
        return (Integer)dataFields.inverse().get((Object)dataField);
    }

    public List<Integer> getIndices() {
        BiMap<Integer, DataField> dataFields = this.getDataFields();
        return dataFields.keySet().stream().sorted().collect(Collectors.toList());
    }

    public DataType getDataType() {
        BiMap<Integer, DataField> dataFields = this.getDataFields();
        Set dataTypes = dataFields.values().stream().map(dataField -> dataField.requireDataType()).collect(Collectors.toSet());
        return (DataType)Iterables.getOnlyElement(dataTypes);
    }

    public OpType getOpType() {
        BiMap<Integer, DataField> dataFields = this.getDataFields();
        Set opTypes = dataFields.values().stream().map(dataField -> dataField.requireOpType()).collect(Collectors.toSet());
        return (OpType)Iterables.getOnlyElement(opTypes);
    }

    public DataField getElement(int index) {
        return (DataField)this.dataFields.get((Object)index);
    }

    public void setElement(int index, DataField dataField) {
        if (dataField.hasExtensions()) {
            throw new IllegalArgumentException();
        }
        if (dataField.hasIntervals() || dataField.hasValues()) {
            throw new IllegalArgumentException();
        }
        this.dataFields.put((Object)index, (Object)dataField);
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public BiMap<Integer, DataField> getDataFields() {
        return this.dataFields;
    }
}

