/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dmg.pmml.PMMLObject;

public class IdentifierUtil {
    private IdentifierUtil() {
    }

    public static String sanitize(String name) {
        name = IdentifierUtil.sanitizeWhitespace(name);
        name = IdentifierUtil.sanitizePunctuation(name);
        StringBuffer sb = new StringBuffer();
        int max = name.length();
        for (int i = 0; i < max; ++i) {
            char c = name.charAt(i);
            if (sb.length() == 0) {
                if (Character.isJavaIdentifierStart(c)) {
                    sb.append(Character.toLowerCase(c));
                    continue;
                }
                if (!Character.isJavaIdentifierPart(c)) continue;
                sb.append('_').append(c);
                continue;
            }
            if (!Character.isJavaIdentifierPart(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String sanitizeWhitespace(String name) {
        Pattern pattern = Pattern.compile("\\s+");
        Matcher matcher = pattern.matcher(name);
        return matcher.replaceAll("_");
    }

    public static String sanitizePunctuation(String name) {
        Pattern pattern = Pattern.compile("\\-+");
        StringBuffer sb = new StringBuffer();
        Matcher matcher = pattern.matcher(name);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            if (start > 0 && IdentifierUtil.isLetterOrDigit(name, start - 1) && end < name.length() && IdentifierUtil.isLetterOrDigit(name, end)) {
                matcher.appendReplacement(sb, "_");
                continue;
            }
            matcher.appendReplacement(sb, matcher.group(0));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static boolean isLetterOrDigit(String string, int index) {
        char c = string.charAt(index);
        return Character.isLetterOrDigit(c);
    }

    public static String create(String prefix, String name) {
        name = name.intern();
        return prefix + "$" + System.identityHashCode(name);
    }

    public static String create(String prefix, PMMLObject object) {
        return prefix + "$" + System.identityHashCode(object);
    }

    public static String create(String prefix, PMMLObject object, String name) {
        return IdentifierUtil.create(IdentifierUtil.create(prefix, object), name);
    }

    public static String create(String prefix, List<?> objects) {
        return prefix + "$" + System.identityHashCode(objects);
    }
}

