/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JStatement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

public class JBlockUtil {
    private JBlockUtil() {
    }

    public static void clear(JBlock block) {
        List content;
        try {
            Field contentField = JBlock.class.getDeclaredField("content");
            if (!contentField.isAccessible()) {
                contentField.setAccessible(true);
            }
            content = (List)contentField.get(block);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
        content.clear();
        block.pos(content.size());
    }

    public static <T> T insert(JBlock block, T object) {
        try {
            Method insertMethod = JBlock.class.getDeclaredMethod("insert", Object.class);
            if (!insertMethod.isAccessible()) {
                insertMethod.setAccessible(true);
            }
            insertMethod.invoke((Object)block, object);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
        return object;
    }

    public static void insertAll(JBlock block, List<?> objects) {
        for (Object object : objects) {
            if (object instanceof JStatement) {
                JStatement statement = (JStatement)object;
                block.add(statement);
                continue;
            }
            JBlockUtil.insert(block, object);
        }
    }

    public static void generateBody(JBlock block, JFormatter formatter) {
        try {
            Method generateBodyMethod = JBlock.class.getDeclaredMethod("generateBody", JFormatter.class);
            if (!generateBodyMethod.isAccessible()) {
                generateBodyMethod.setAccessible(true);
            }
            generateBodyMethod.invoke((Object)block, formatter);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
    }
}

