/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JStatement;
import java.util.List;
import java.util.Objects;
import org.jpmml.translator.JBlockUtil;
import org.jpmml.translator.JOpUtil;

public class JIfStatement
implements JStatement {
    private JExpression expression = null;
    private JBlock _then = new JBlock();
    private JBlock _else = null;

    public JIfStatement(JExpression expression) {
        this.expression = Objects.requireNonNull(expression);
    }

    public JBlock _then() {
        return this._then;
    }

    public boolean hasElse() {
        return this._else != null;
    }

    public JIfStatement _elseif(JIfStatement ifStatement) {
        if (this._else != null) {
            throw new IllegalStateException();
        }
        this._else = new JBlock(false, false);
        this._else.add((JStatement)ifStatement);
        return ifStatement;
    }

    public JBlock _else() {
        if (this._else == null) {
            this._else = new JBlock();
        }
        return this._else;
    }

    public void state(JFormatter formatter) {
        if (Objects.equals(JExpr.TRUE, this.expression)) {
            JBlockUtil.generateBody(this._then, formatter);
            return;
        }
        if (Objects.equals(JExpr.FALSE, this.expression)) {
            JBlockUtil.generateBody(this._else, formatter);
            return;
        }
        if (JOpUtil.hasTopOp(this.expression)) {
            formatter.p("if ").g((JGenerable)this.expression);
        } else {
            formatter.p("if (").g((JGenerable)this.expression).p(")");
        }
        formatter.g((JGenerable)this._then);
        if (this._else != null && !this._else.isEmpty()) {
            Object elseObject;
            formatter.p("else");
            formatter.g((JGenerable)this._else);
            List elseObjects = this._else.getContents();
            if (elseObjects.size() == 1 && (elseObject = elseObjects.get(0)) instanceof JIfStatement) {
                return;
            }
        }
        formatter.nl();
    }
}

