/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jpmml.translator.OperableRef;

public class Scope {
    private JBlock block = null;
    private Map<String, JVar> variables = null;
    private Set<String> nonMissingVariables = null;
    private boolean open = true;
    public static final String VAR_ARGUMENTS = "arguments";
    public static final String VAR_CONTEXT = "context";
    public static final String VAR_VALUEFACTORY = "valueFactory";

    public Scope(JBlock block) {
        this.setBlock(block);
    }

    public void cleanVariableInfo() {
        if (this.variables != null) {
            this.variables.clear();
        }
        if (this.nonMissingVariables != null) {
            this.nonMissingVariables.clear();
        }
    }

    public boolean isNonMissing(OperableRef operableRef) {
        JExpression expression = operableRef.getExpression();
        if (expression instanceof JVar) {
            JVar variable = (JVar)expression;
            return this.isNonMissing(variable);
        }
        return false;
    }

    public boolean isNonMissing(JVar variable) {
        return this.nonMissingVariables != null && this.nonMissingVariables.contains(variable.name());
    }

    public void markNonMissing(OperableRef operableRef) {
        JExpression expression = operableRef.getExpression();
        if (expression instanceof JVar) {
            JVar variable = (JVar)expression;
            this.markNonMissing(variable);
        }
    }

    public void markNonMissing(JVar variable) {
        if (this.nonMissingVariables == null) {
            this.nonMissingVariables = new LinkedHashSet<String>();
        }
        this.nonMissingVariables.add(variable.name());
    }

    public Scope ensureOpen() {
        boolean open = this.isOpen();
        if (!open) {
            throw new IllegalStateException();
        }
        return this;
    }

    public Scope close() {
        this.setOpen(false);
        return this;
    }

    public JVar declare(JType type, String name, JExpression initializer) {
        JBlock block = this.getBlock();
        JVar variable = block.decl(type, name, initializer);
        return this.putVariable(variable);
    }

    public JVar getVariable(String name) {
        if (this.variables == null) {
            return null;
        }
        return this.variables.get(name);
    }

    public JVar putVariable(JVar variable) {
        if (this.variables == null) {
            this.variables = new LinkedHashMap<String, JVar>();
        }
        this.variables.put(variable.name(), variable);
        return variable;
    }

    public JBlock getBlock() {
        return this.block;
    }

    private void setBlock(JBlock block) {
        this.block = Objects.requireNonNull(block);
    }

    public boolean isOpen() {
        return this.open;
    }

    private void setOpen(boolean open) {
        this.open = open;
    }
}

