/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator.tree;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.ComplexArray;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.visitors.AbstractVisitor;

public class DiscreteValueFinder
extends AbstractVisitor {
    private Map<String, Set<Object>> fieldValues = new LinkedHashMap<String, Set<Object>>();

    public VisitorAction visit(SimplePredicate simplePredicate) {
        String fieldName = simplePredicate.requireField();
        SimplePredicate.Operator operator = simplePredicate.requireOperator();
        switch (operator) {
            case EQUAL: 
            case NOT_EQUAL: {
                Object value = simplePredicate.requireValue();
                this.addValue(fieldName, value);
                break;
            }
        }
        return super.visit(simplePredicate);
    }

    public VisitorAction visit(SimpleSetPredicate simpleSetPredicate) {
        String fieldName = simpleSetPredicate.requireField();
        SimpleSetPredicate.BooleanOperator booleanOperator = simpleSetPredicate.requireBooleanOperator();
        ComplexArray array = (ComplexArray)simpleSetPredicate.requireArray();
        Collection values = array.getValue();
        switch (booleanOperator) {
            case IS_IN: 
            case IS_NOT_IN: {
                for (Object value : values) {
                    this.addValue(fieldName, value);
                }
                break;
            }
        }
        return super.visit(simpleSetPredicate);
    }

    public void addValue(String fieldName, Object value) {
        Map<String, Set<Object>> fieldValues = this.getFieldValues();
        Set<Object> values = fieldValues.get(fieldName);
        if (values == null) {
            values = new LinkedHashSet<Object>();
            fieldValues.put(fieldName, values);
        }
        values.add(value);
    }

    public Map<String, Set<Object>> getFieldValues() {
        return this.fieldValues;
    }
}

