/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.transpiler.testing;

import com.google.common.base.Equivalence;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.writer.FileCodeWriter;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.jpmml.evaluator.LoadingModelEvaluatorBuilder;
import org.jpmml.evaluator.OutputFilters;
import org.jpmml.evaluator.PMMLTransformer;
import org.jpmml.evaluator.ResultField;
import org.jpmml.evaluator.testing.SimpleArchiveBatch;
import org.jpmml.model.JavaSerializer;
import org.jpmml.model.SerializationUtil;
import org.jpmml.model.Serializer;
import org.jpmml.model.visitors.VisitorBattery;
import org.jpmml.translator.visitors.ModelTranslatorVisitorBattery;
import org.jpmml.transpiler.InMemoryTranspiler;
import org.jpmml.transpiler.TranspilerTransformer;
import org.jpmml.transpiler.testing.TranspilerBatchTest;

public abstract class TranspilerBatch
extends SimpleArchiveBatch {
    private String explodedArchiveDir = System.getProperty(TranspilerBatch.class.getName() + ".explodedArchiveDir", null);

    public TranspilerBatch(String algorithm, String dataset, Predicate<ResultField> columnFilter, Equivalence<Object> equivalence) {
        super(algorithm, dataset, columnFilter, equivalence);
    }

    public abstract TranspilerBatchTest getArchiveBatchTest();

    protected LoadingModelEvaluatorBuilder createLoadingModelEvaluatorBuilder() {
        LoadingModelEvaluatorBuilder evaluatorBuilder = super.createLoadingModelEvaluatorBuilder();
        evaluatorBuilder.setVisitors((VisitorBattery)new ModelTranslatorVisitorBattery()).setOutputFilter(OutputFilters.KEEP_FINAL_RESULTS);
        return evaluatorBuilder;
    }

    protected List<PMMLTransformer<?>> getTransformers() {
        InMemoryTranspiler transpiler = new InMemoryTranspiler(null){

            @Override
            public PMML transpile(PMML xmlPMML) throws IOException {
                PMML javaPMML = super.transpile(xmlPMML);
                TranspilerBatch.this.validatePMML(javaPMML);
                return javaPMML;
            }

            @Override
            protected JCodeModel translate(PMML pmml) throws IOException {
                JCodeModel codeModel = super.translate(pmml);
                this.export(codeModel);
                return codeModel;
            }

            @Override
            protected JCodeModel compile(JCodeModel codeModel) throws IOException {
                codeModel = super.compile(codeModel);
                this.export(codeModel);
                return codeModel;
            }

            private void export(JCodeModel codeModel) throws IOException {
                if (TranspilerBatch.this.explodedArchiveDir != null) {
                    boolean success;
                    File explodedArchiveDir = new File(TranspilerBatch.this.explodedArchiveDir + "/" + TranspilerBatch.this.getAlgorithm() + TranspilerBatch.this.getDataset());
                    if (!explodedArchiveDir.exists() && !(success = explodedArchiveDir.mkdirs())) {
                        throw new IOException();
                    }
                    FileCodeWriter codeWriter = new FileCodeWriter(explodedArchiveDir);
                    codeModel.build((CodeWriter)codeWriter);
                }
            }
        };
        return Collections.singletonList(new TranspilerTransformer(transpiler));
    }

    protected void validatePMML(PMML pmml) throws IOException {
        TranspilerBatchTest transpilerTest = this.getArchiveBatchTest();
        Visitor checker = transpilerTest.getChecker();
        if (checker != null) {
            checker.applyTo((Visitable)pmml);
        }
        Class<?> pmmlClazz = pmml.getClass();
        ClassLoader clazzLoader = pmmlClazz.getClassLoader();
        JavaSerializer serializer = new JavaSerializer(clazzLoader);
        try {
            PMML pMML = (PMML)SerializationUtil.clone((Serializer)serializer, (PMMLObject)pmml);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

