/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.Expression;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.ServiceFactory;
import org.jpmml.model.PMMLException;
import org.jpmml.model.UnsupportedElementException;
import org.jpmml.model.UnsupportedMarkupException;
import org.jpmml.translator.ExpressionTranslator;

public class ExpressionTranslatorFactory
extends ServiceFactory<Expression, ExpressionTranslator<?>> {
    private static final boolean ENABLED = Boolean.parseBoolean(System.getProperty(ExpressionTranslatorFactory.class.getName() + "#ENABLED", "true"));
    private static final ExpressionTranslatorFactory INSTANCE = new ExpressionTranslatorFactory();

    protected ExpressionTranslatorFactory() {
        super(Expression.class, ExpressionTranslator.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExpressionTranslator<?> newExpressionTranslator(Expression expression) {
        Objects.requireNonNull(expression);
        if (!ENABLED) {
            throw new UnsupportedElementException((PMMLObject)expression);
        }
        try {
            List expressionTranslatorClazzes = this.getServiceProviderClasses(expression.getClass());
            for (Class expressionTranslatorClazz : expressionTranslatorClazzes) {
                Constructor<?> constructor = ExpressionTranslatorFactory.findConstructor(expressionTranslatorClazz);
                try {
                    return (ExpressionTranslator)constructor.newInstance(expression);
                }
                catch (InvocationTargetException ite) {
                    Throwable cause = ite.getCause();
                    if (!(cause instanceof PMMLException)) throw ite;
                    if (cause instanceof UnsupportedMarkupException) continue;
                    throw (PMMLException)cause;
                    throw new UnsupportedElementException((PMMLObject)expression);
                }
            }
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ExpressionTranslatorFactory getInstance() {
        return INSTANCE;
    }

    private static Constructor<?> findConstructor(Class<? extends ExpressionTranslator<?>> expressionTranslatorClazz) throws NoSuchMethodException {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = expressionTranslatorClazz.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 1 || !Expression.class.isAssignableFrom(parameterTypes[0])) continue;
            return constructor;
        }
        throw new NoSuchMethodException();
    }
}

