/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.translator.ArrayFpPrimitiveEncoder;
import org.jpmml.translator.ArrayInfo;
import org.jpmml.translator.Encoder;
import org.jpmml.translator.FieldInfo;
import org.jpmml.translator.FieldValueRef;
import org.jpmml.translator.FpPrimitiveRef;
import org.jpmml.translator.FunctionInvocation;
import org.jpmml.translator.IdentifierUtil;
import org.jpmml.translator.MethodScope;
import org.jpmml.translator.OperableRef;
import org.jpmml.translator.TermFrequencyEncoder;
import org.jpmml.translator.TranslationContext;

public class FpPrimitiveEncoder
implements Encoder {
    public static final JExpression INIT_VALUE_FLOAT = JExpr.lit((float)-999.0f);
    public static final JExpression INIT_VALUE_DOUBLE = JExpr.lit((double)-999.0);
    public static final JExpression NAN_VALUE_FLOAT = JExpr.lit((float)Float.NaN);
    public static final JExpression NAN_VALUE_DOUBLE = JExpr.lit((double)Double.NaN);

    @Override
    public String getVariableName(FieldInfo fieldInfo) {
        Field<?> field = fieldInfo.getField();
        return IdentifierUtil.sanitize(field.requireName()) + "2fp";
    }

    @Override
    public Object encode(Object value) {
        if (value == null) {
            return Double.NaN;
        }
        return value;
    }

    @Override
    public OperableRef ref(JExpression expression) {
        return new FpPrimitiveRef(expression);
    }

    @Override
    public FieldInfo follow(FieldInfo fieldInfo) {
        Field<?> refField;
        FieldInfo result = fieldInfo;
        for (FieldInfo ref = fieldInfo.getRef(); ref != null && FpPrimitiveEncoder.isCastable(refField = ref.getField()); ref = ref.getRef()) {
            result = ref;
        }
        return result;
    }

    @Override
    public JMethod createEncoderMethod(FieldInfo fieldInfo, TranslationContext context) {
        Field<?> refField;
        JPrimitiveType returnType;
        Object name;
        Field<?> field = fieldInfo.getField();
        DataType dataType = field.requireDataType();
        switch (dataType) {
            case INTEGER: {
                name = "Integer";
                returnType = (JPrimitiveType)context._ref(Integer.TYPE);
                break;
            }
            case FLOAT: {
                name = "Float";
                returnType = (JPrimitiveType)context._ref(Float.TYPE);
                break;
            }
            case DOUBLE: {
                name = "Double";
                returnType = (JPrimitiveType)context._ref(Double.TYPE);
                break;
            }
            default: {
                throw new IllegalArgumentException(dataType.toString());
            }
        }
        ArrayList<JPrimitiveType> castSequenceTypes = null;
        block10: for (FieldInfo ref = fieldInfo.getRef(); ref != null && FpPrimitiveEncoder.isCastable(refField = ref.getField()); ref = ref.getRef()) {
            field = refField;
            dataType = field.requireDataType();
            if (castSequenceTypes == null) {
                castSequenceTypes = new ArrayList<JPrimitiveType>();
            }
            switch (dataType) {
                case INTEGER: {
                    name = (String)name + "Integer";
                    castSequenceTypes.add((JPrimitiveType)context._ref(Integer.TYPE));
                    continue block10;
                }
                case FLOAT: {
                    name = (String)name + "Float";
                    castSequenceTypes.add((JPrimitiveType)context._ref(Float.TYPE));
                    continue block10;
                }
                case DOUBLE: {
                    name = (String)name + "Double";
                    castSequenceTypes.add((JPrimitiveType)context._ref(Double.TYPE));
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException(dataType.toString());
                }
            }
        }
        name = "to" + (String)name + "Primitive";
        return this.createEncoderMethod(fieldInfo, returnType, (String)name, castSequenceTypes, dataType, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMethod createEncoderMethod(FieldInfo fieldInfo, JPrimitiveType returnType, String name, List<JPrimitiveType> castSequenceTypes, DataType dataType, TranslationContext context) {
        JDefinedClass owner = context.getOwner();
        JClass stringClazz = context.ref(String.class);
        JMethod method = owner.getMethod(name, new JType[]{stringClazz});
        if (method != null) {
            return method;
        }
        method = owner.method(12, (JType)returnType, name);
        JVar nameParam = method.param((JType)stringClazz, "name");
        try {
            context.pushScope(new MethodScope(method));
            JVar valueVar = context.declare(FieldValue.class, "value", (JExpression)context.invoke((JExpression)JExpr.refthis((String)"context"), "evaluate", nameParam));
            FieldValueRef fieldValueRef = new FieldValueRef(valueVar, dataType);
            JExpression nanExpr = FpPrimitiveEncoder.fpNanValue(returnType, context);
            JExpression javaValueExpr = FpPrimitiveEncoder.fpJavaValue((JExpression)fieldValueRef.asJavaPrimitiveValue(), returnType, castSequenceTypes, context);
            context._return(valueVar.eq(JExpr._null()), nanExpr, javaValueExpr);
        }
        finally {
            context.popScope();
        }
        return method;
    }

    @Override
    public JExpression createInitExpression(FieldInfo fieldInfo, TranslationContext context) {
        Field<?> field = fieldInfo.getField();
        DataType dataType = field.requireDataType();
        switch (dataType) {
            case INTEGER: {
                return INIT_VALUE_DOUBLE;
            }
            case FLOAT: {
                return INIT_VALUE_FLOAT;
            }
            case DOUBLE: {
                return INIT_VALUE_DOUBLE;
            }
        }
        throw new IllegalArgumentException(dataType.toString());
    }

    public static FpPrimitiveEncoder create(FieldInfo fieldInfo, Map<Field<?>, ArrayInfo> fieldArrayInfos) {
        Field<?> field;
        while (fieldInfo != null && FpPrimitiveEncoder.isCastable(field = fieldInfo.getField())) {
            ArrayInfo arrayInfo = fieldArrayInfos.get(field);
            if (arrayInfo != null) {
                Integer index = arrayInfo.getIndex((DataField)field);
                return new ArrayFpPrimitiveEncoder(arrayInfo).setIndex(index);
            }
            FunctionInvocation functionInvocation = fieldInfo.getFunctionInvocation();
            if (functionInvocation != null) {
                if (!(functionInvocation instanceof FunctionInvocation.Tf)) break;
                return new TermFrequencyEncoder();
            }
            fieldInfo = fieldInfo.getRef();
        }
        return new FpPrimitiveEncoder();
    }

    protected static boolean isCastable(Field<?> field) {
        DataType dataType = field.requireDataType();
        switch (dataType) {
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: {
                break;
            }
            default: {
                return false;
            }
        }
        OpType opType = field.requireOpType();
        switch (opType) {
            case CONTINUOUS: {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected static JExpression fpNanValue(JPrimitiveType returnType, TranslationContext context) {
        JCodeModel codeModel = context.getCodeModel();
        if (codeModel.FLOAT.equals(returnType)) {
            return NAN_VALUE_FLOAT;
        }
        if (codeModel.DOUBLE.equals(returnType)) {
            return NAN_VALUE_DOUBLE;
        }
        throw new IllegalArgumentException();
    }

    protected static JExpression fpJavaValue(JExpression javaValueExpr, JPrimitiveType returnType, List<JPrimitiveType> castSequenceTypes, TranslationContext context) {
        if (castSequenceTypes != null) {
            castSequenceTypes.add(0, returnType);
            castSequenceTypes.remove(castSequenceTypes.size() - 1);
            for (int i = castSequenceTypes.size() - 1; i > -1; --i) {
                javaValueExpr = JExpr.cast((JType)((JType)castSequenceTypes.get(i)), (JExpression)javaValueExpr);
            }
        }
        return javaValueExpr;
    }
}

