/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.jpmml.translator.JClassInitializer;
import org.jpmml.translator.PMMLObjectUtil;
import org.jpmml.translator.TranslationContext;

public class JDirectInitializer
extends JClassInitializer {
    public JDirectInitializer(TranslationContext context) {
        super(context);
    }

    @Override
    public void add(JStatement statement) {
        TranslationContext context = this.getContext();
        JDefinedClass owner = context.getOwner();
        JBlock init = owner.init();
        init.add(statement);
    }

    public JFieldVar initLambdas(String name, JClass type, List<JMethod> methods) {
        TranslationContext context = this.getContext();
        JFieldVar constant = JDirectInitializer.createListConstant(name, type, context);
        JExpression[] lambdas = (JExpression[])methods.stream().map(method -> JExpr.direct((String)JDirectInitializer.formatLambda(method))).toArray(JExpression[]::new);
        constant.init((JExpression)context.staticInvoke(Arrays.class, "asList", (Object[])lambdas));
        return constant;
    }

    public JFieldVar initTargetCategories(String name, List<?> categories) {
        TranslationContext context = this.getContext();
        JFieldVar constant = JDirectInitializer.createListConstant(name, context.ref(Object.class), context);
        JExpression[] literals = (JExpression[])categories.stream().map(category -> PMMLObjectUtil.createExpression(category, context)).toArray(JExpression[]::new);
        constant.init((JExpression)context.staticInvoke(Arrays.class, "asList", (Object[])literals));
        return constant;
    }

    private static String formatLambda(JMethod method) {
        JDefinedClass outer;
        try {
            Field field = JMethod.class.getDeclaredField("outer");
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            outer = (JDefinedClass)field.get(method);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
        return outer.name() + "::" + method.name();
    }
}

