/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.google.common.collect.Iterables;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.jpmml.evaluator.TokenizedString;
import org.jpmml.translator.JClassInitializer;
import org.jpmml.translator.TranslationContext;

public abstract class JResourceInitializer
extends JClassInitializer {
    public JResourceInitializer(TranslationContext context) {
        super(context);
    }

    public abstract void assign(JVar var1, JExpression var2);

    public abstract JInvocation initQNames(QName[] var1);

    public abstract JInvocation initValues(JType var1, Object[] var2);

    public abstract JInvocation initTokenizedStringLists(TokenizedString[] var1);

    public abstract JInvocation initNumbers(JType var1, Number[] var2);

    public abstract JInvocation initNumbersList(JType var1, List<Number[]> var2);

    public abstract JInvocation initNumberArraysList(JType var1, List<Number[][]> var2, int var3);

    public abstract JInvocation initNumbersMap(JType var1, JType var2, Map<?, Number> var3);

    public JFieldVar initTokenizedStringLists(String name, TokenizedString[] tokenizedStrings) {
        TranslationContext context = this.getContext();
        JFieldVar constant = JResourceInitializer.createListConstant(name, context.ref(TokenizedString.class), context);
        this.assign((JVar)constant, (JExpression)this.initTokenizedStringLists(tokenizedStrings));
        return constant;
    }

    public JFieldVar initNumbers(String name, Number[] values) {
        TranslationContext context = this.getContext();
        Class<?> valueClazz = JResourceInitializer.getValueClass(Arrays.asList(values), Number.class);
        JClass type = context.ref(valueClazz);
        JFieldVar constant = JResourceInitializer.createListConstant(name, type, context);
        this.assign((JVar)constant, (JExpression)this.initNumbers((JType)type, values));
        return constant;
    }

    public JFieldVar initNumbersList(String name, List<Number[]> elements) {
        TranslationContext context = this.getContext();
        Collection values = elements.stream().flatMap(Arrays::stream).collect(Collectors.toList());
        Class<?> valueClazz = JResourceInitializer.getValueClass(values, Number.class);
        JClass type = context.ref(valueClazz).array();
        JFieldVar constant = JResourceInitializer.createListConstant(name, type, context);
        this.assign((JVar)constant, (JExpression)this.initNumbersList((JType)type, elements));
        return constant;
    }

    public JFieldVar initNumberArraysList(String name, List<Number[][]> elements, int length) {
        TranslationContext context = this.getContext();
        Collection values = elements.stream().flatMap(Arrays::stream).flatMap(Arrays::stream).collect(Collectors.toList());
        Class<?> valuesClazz = JResourceInitializer.getValueClass(values, Number.class);
        JClass type = context.ref(valuesClazz).array().array();
        JFieldVar constant = JResourceInitializer.createListConstant(name, type, context);
        this.assign((JVar)constant, (JExpression)this.initNumberArraysList((JType)type, elements, length));
        return constant;
    }

    public JFieldVar initNumbersMap(String name, Map<?, Number> map) {
        TranslationContext context = this.getContext();
        Set<?> keys = map.keySet();
        Collection<Number> values = map.values();
        Class<?> keysClazz = JResourceInitializer.getValueClass(keys);
        Class<?> valuesClazz = JResourceInitializer.getValueClass(values, Number.class);
        JClass keyType = context.ref(keysClazz);
        JClass valueType = context.ref(valuesClazz);
        JFieldVar constant = JResourceInitializer.createMapConstant(name, keyType, valueType, context);
        this.assign((JVar)constant, (JExpression)this.initNumbersMap((JType)keyType, (JType)valueType, map));
        return constant;
    }

    public static boolean isExternalizable(Class<?> clazz) {
        if (Objects.equals(clazz, String.class)) {
            return true;
        }
        return Objects.equals(clazz, Integer.class) || Objects.equals(clazz, Float.class) || Objects.equals(clazz, Double.class);
    }

    public static boolean isExternalizable(Collection<?> values) {
        Class<?> valueClazz = JResourceInitializer.getValueClass(values);
        return JResourceInitializer.isExternalizable(valueClazz);
    }

    public static Class<?> getValueClass(Collection<?> values) {
        return JResourceInitializer.getValueClass(values, Object.class);
    }

    public static Class<?> getValueClass(Collection<?> values, Class<?> defaultClazz) {
        Set valueClazzes = values.stream().map(value -> value.getClass()).collect(Collectors.toSet());
        if (valueClazzes.size() == 1) {
            return (Class)Iterables.getOnlyElement(valueClazzes);
        }
        return defaultClazz;
    }
}

