/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import java.util.Objects;
import java.util.Set;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.jpmml.evaluator.ModelManagerFactory;
import org.jpmml.model.UnsupportedElementException;
import org.jpmml.translator.ModelTranslator;

public class ModelTranslatorFactory
extends ModelManagerFactory<ModelTranslator<?>> {
    private static final boolean ENABLED = Boolean.parseBoolean(System.getProperty(ModelTranslatorFactory.class.getName() + "#ENABLED", "true"));
    private static final ModelTranslatorFactory INSTANCE = new ModelTranslatorFactory();

    protected ModelTranslatorFactory() {
        super(ModelTranslator.class);
    }

    public ModelTranslator<?> newModelTranslator(PMML pmml, Model model) {
        return (ModelTranslator)this.newModelManager(pmml, model);
    }

    public ModelTranslator<?> newModelTranslator(PMML pmml, Model model, Set<ResultFeature> extraResultFeature) {
        return this.newModelManager(pmml, model, (Set)extraResultFeature);
    }

    public ModelTranslator<?> newModelManager(PMML pmml, Model model, Set<ResultFeature> extraResultFeatures) {
        Objects.requireNonNull(pmml);
        Objects.requireNonNull(model);
        if (!ENABLED) {
            throw new UnsupportedElementException((PMMLObject)model);
        }
        return (ModelTranslator)super.newModelManager(pmml, model, extraResultFeatures);
    }

    public static ModelTranslatorFactory getInstance() {
        return INSTANCE;
    }
}

