/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator.tree;

import com.google.common.base.Functions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.Streams;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dmg.pmml.ComplexArray;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.False;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.True;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.PMMLAttributes;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.jpmml.evaluator.TokenizedString;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.java.JavaModel;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.UnsupportedAttributeException;
import org.jpmml.model.UnsupportedElementException;
import org.jpmml.translator.ArrayFpPrimitiveEncoder;
import org.jpmml.translator.ArrayInfo;
import org.jpmml.translator.ArrayInfoMap;
import org.jpmml.translator.FieldInfo;
import org.jpmml.translator.FieldInfoMap;
import org.jpmml.translator.FpPrimitiveEncoder;
import org.jpmml.translator.FunctionInvocation;
import org.jpmml.translator.IdentifierUtil;
import org.jpmml.translator.JBinaryFileInitializer;
import org.jpmml.translator.JIfStatement;
import org.jpmml.translator.MethodScope;
import org.jpmml.translator.ModelTranslator;
import org.jpmml.translator.OperableRef;
import org.jpmml.translator.OrdinalEncoder;
import org.jpmml.translator.PMMLObjectUtil;
import org.jpmml.translator.Scope;
import org.jpmml.translator.TermFrequencyEncoder;
import org.jpmml.translator.TextIndexUtil;
import org.jpmml.translator.TranslationContext;
import org.jpmml.translator.ValueFactoryRef;
import org.jpmml.translator.ValueMapBuilder;
import org.jpmml.translator.tree.CountingActiveFieldFinder;
import org.jpmml.translator.tree.DiscreteValueFinder;
import org.jpmml.translator.tree.NodeGroup;
import org.jpmml.translator.tree.NodeGroupUtil;
import org.jpmml.translator.tree.NodeScope;
import org.jpmml.translator.tree.NodeScoreDistributionManager;
import org.jpmml.translator.tree.NodeScoreManager;
import org.jpmml.translator.tree.Scorer;

public class TreeModelTranslator
extends ModelTranslator<TreeModel> {
    public TreeModelTranslator(PMML pmml, TreeModel treeModel) {
        super(pmml, treeModel);
        TreeModel.MissingValueStrategy missingValueStrategy = treeModel.getMissingValueStrategy();
        switch (missingValueStrategy) {
            case NONE: 
            case NULL_PREDICTION: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum)missingValueStrategy);
            }
        }
        TreeModel.NoTrueChildStrategy noTrueChildStrategy = treeModel.getNoTrueChildStrategy();
        switch (noTrueChildStrategy) {
            case RETURN_LAST_PREDICTION: 
            case RETURN_NULL_PREDICTION: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum)noTrueChildStrategy);
            }
        }
        Node root = treeModel.requireNode();
        True _true = (True)root.requirePredicate(True.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMethod translateRegressor(TranslationContext context) {
        TreeModel treeModel = (TreeModel)this.getModel();
        Node node = treeModel.getNode();
        final JDefinedClass owner = context.getOwner();
        NodeScoreManager scoreManager = new NodeScoreManager((JType)context.ref(Number.class), IdentifierUtil.create("scores", (PMMLObject)node)){
            {
                super(componentType, name);
                this.initArrayVar(owner);
                this.initArray();
            }
        };
        FieldInfoMap fieldInfos = this.getFieldInfos(Collections.singleton(node));
        JMethod evaluateNodeMethod = TreeModelTranslator.createEvaluatorMethod(Integer.TYPE, (PMMLObject)node, false, context);
        try {
            context.pushScope(new MethodScope(evaluateNodeMethod));
            TreeModelTranslator.translateNode(treeModel, node, scoreManager, fieldInfos, context);
        }
        finally {
            context.popScope();
        }
        JMethod evaluateTreeModelMethod = TreeModelTranslator.createEvaluatorMethod(Number.class, (PMMLObject)treeModel, false, context);
        try {
            context.pushScope(new MethodScope(evaluateTreeModelMethod));
            JVar indexVar = context.declare(Integer.TYPE, "index", (JExpression)TreeModelTranslator.createEvaluatorMethodInvocation(evaluateNodeMethod, context));
            context._returnIf(indexVar.eq(NodeScoreManager.RESULT_MISSING), JExpr._null());
            context._return(scoreManager.getComponent((JExpression)indexVar));
        }
        finally {
            context.popScope();
        }
        return evaluateTreeModelMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMethod translateClassifier(TranslationContext context) {
        final TreeModel treeModel = (TreeModel)this.getModel();
        Node node = treeModel.getNode();
        Object[] categories = this.getTargetCategories();
        final JDefinedClass owner = context.getOwner();
        NodeScoreDistributionManager<Number> scoreDistributionManager = new NodeScoreDistributionManager<Number>((JType)context.ref(Number[].class), IdentifierUtil.create("scores", (PMMLObject)node), categories){
            private ValueFactory<Number> valueFactory;
            {
                super(componentType, name, categories);
                this.valueFactory = ModelTranslator.getValueFactory((Model)treeModel);
                this.initArrayVar(owner);
                this.initArray();
            }

            @Override
            public ValueFactory<Number> getValueFactory() {
                return this.valueFactory;
            }
        };
        FieldInfoMap fieldInfos = this.getFieldInfos(Collections.singleton(node));
        JMethod evaluateNodeMethod = TreeModelTranslator.createEvaluatorMethod(Integer.TYPE, (PMMLObject)node, false, context);
        try {
            context.pushScope(new MethodScope(evaluateNodeMethod));
            TreeModelTranslator.translateNode(treeModel, node, scoreDistributionManager, fieldInfos, context);
        }
        finally {
            context.popScope();
        }
        JMethod evaluateTreeModelMethod = TreeModelTranslator.createEvaluatorMethod(Classification.class, (PMMLObject)treeModel, true, context);
        try {
            context.pushScope(new MethodScope(evaluateTreeModelMethod));
            JVar indexVar = context.declare(Integer.TYPE, "index", (JExpression)TreeModelTranslator.createEvaluatorMethodInvocation(evaluateNodeMethod, context));
            context._returnIf(indexVar.eq(NodeScoreDistributionManager.RESULT_MISSING), JExpr._null());
            JVar scoreVar = context.declare(Number[].class, "score", scoreDistributionManager.getComponent((JExpression)indexVar));
            ValueMapBuilder valueMapBuilder = TreeModelTranslator.createScoreDistribution(categories, scoreVar, context);
            context._return((JExpression)context._new(ProbabilityDistribution.class, valueMapBuilder));
        }
        finally {
            context.popScope();
        }
        return evaluateTreeModelMethod;
    }

    @Override
    public FieldInfoMap getFieldInfos(Set<? extends PMMLObject> bodyObjects) {
        FieldInfoMap fieldInfos = super.getFieldInfos(bodyObjects);
        ArrayInfoMap arrayInfos = this.getArrayInfos();
        if (!arrayInfos.isEmpty()) {
            this.declareArrayFields(arrayInfos.values());
        }
        fieldInfos = TreeModelTranslator.enhanceFieldInfos(bodyObjects, fieldInfos, arrayInfos);
        return fieldInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S> void translateNode(TreeModel treeModel, Node root, Scorer<S> scorer, FieldInfoMap fieldInfos, TranslationContext context) {
        True _true = (True)root.requirePredicate(True.class);
        JBlock block = context.block();
        JIfStatement ifStatement = new JIfStatement(JExpr.TRUE);
        block.add((JStatement)ifStatement);
        try {
            context.pushScope(new NodeScope(ifStatement));
            TreeModelTranslator.translateNode(treeModel, root, TreeModelTranslator.collectDependentNodes(root, Collections.emptyList()), null, scorer, fieldInfos, context);
        }
        finally {
            context.popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S> void translateNode(TreeModel treeModel, Node node, List<Node> dependentNodes, Set<String> declarableNames, Scorer<S> scorer, FieldInfoMap fieldInfos, TranslationContext context) {
        block19: {
            S score = scorer.prepare(node);
            NodeScope nodeScope = TreeModelTranslator.translatePredicate(treeModel, node, dependentNodes, scorer, fieldInfos, context);
            try {
                context.pushScope(nodeScope);
                if (node.hasNodes()) {
                    List children = node.getNodes();
                    List<NodeGroup> nodeGroups = NodeGroupUtil.group(children);
                    if (declarableNames == null) {
                        if (nodeGroups.size() > 0) {
                            Map leadingNameCounts = nodeGroups.stream().map(nodeGroup -> {
                                Predicate predicate = nodeGroup.getPredicate(0);
                                if (predicate instanceof HasFieldReference) {
                                    HasFieldReference hasFieldReference = (HasFieldReference)predicate;
                                    return hasFieldReference.requireField();
                                }
                                return null;
                            }).filter(Objects::nonNull).collect(Collectors.groupingBy(Functions.identity(), Collectors.counting()));
                            declarableNames = leadingNameCounts.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(entry -> (String)entry.getKey()).collect(Collectors.toCollection(LinkedHashSet::new));
                        } else {
                            declarableNames = Collections.emptySet();
                        }
                    }
                    JIfStatement firstIfStatement = null;
                    int offset = 0;
                    for (int i = 0; i < nodeGroups.size(); ++i) {
                        NodeGroup nodeGroup2 = nodeGroups.get(i);
                        TreeModelTranslator.translateNodeGroup(treeModel, nodeGroup2, nodeGroups, declarableNames, scorer, fieldInfos, context);
                        JIfStatement ifStatement = (JIfStatement)nodeScope.chainContent(offset);
                        if (i == 0) {
                            firstIfStatement = ifStatement;
                        }
                        if (i < nodeGroups.size() - 1) {
                            context._comment("break");
                        }
                        offset = nodeScope.reInit();
                    }
                    TreeModel.NoTrueChildStrategy noTrueChildStrategy = treeModel.getNoTrueChildStrategy();
                    switch (noTrueChildStrategy) {
                        case RETURN_NULL_PREDICTION: {
                            if (score == null) break;
                            score = null;
                            break;
                        }
                        case RETURN_LAST_PREDICTION: {
                            break;
                        }
                        default: {
                            throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum)noTrueChildStrategy);
                        }
                    }
                    if (firstIfStatement == null || firstIfStatement.hasElse()) {
                        throw new IllegalStateException();
                    }
                    context.pushScope(new Scope(firstIfStatement._else()));
                    try {
                        scorer.yield(score, context);
                        break block19;
                    }
                    finally {
                        context.popScope();
                    }
                }
                if (score == null) {
                    throw new MissingAttributeException((PMMLObject)node, PMMLAttributes.COMPLEXNODE_SCORE);
                }
                scorer.yield(score, context);
            }
            finally {
                context.popScope();
            }
        }
    }

    private static <S> void translateNodeGroup(TreeModel treeModel, NodeGroup nodeGroup, List<NodeGroup> nodeGroups, Set<String> declarableNames, Scorer<S> scorer, FieldInfoMap fieldInfos, TranslationContext context) {
        NodeGroup nodes = nodeGroup;
        if (!declarableNames.isEmpty()) {
            Iterator<String> nameIt = declarableNames.iterator();
            while (nameIt.hasNext()) {
                String name = nameIt.next();
                if (!TreeModelTranslator.usesField(nodes, name)) continue;
                FieldInfo fieldInfo = fieldInfos.require(name);
                context.ensureOperable(fieldInfo, method -> true);
                nameIt.remove();
            }
        }
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = (Node)nodes.get(i);
            List<Node> dependentNodes = TreeModelTranslator.collectDependentNodes(node, nodes.subList(i + 1, nodes.size()));
            if (i == 0) {
                dependentNodes = new ArrayList<Node>(dependentNodes);
                int index = nodeGroups.indexOf(nodeGroup);
                if (index < 0) {
                    throw new IllegalArgumentException();
                }
                for (int j = index + 1; j < nodeGroups.size(); ++j) {
                    NodeGroup siblingNodeGroup = nodeGroups.get(j);
                    dependentNodes.addAll(siblingNodeGroup);
                }
            }
            TreeModelTranslator.translateNode(treeModel, node, dependentNodes, declarableNames, scorer, fieldInfos, context);
        }
    }

    public static <S> NodeScope translatePredicate(TreeModel treeModel, Node node, List<Node> dependentNodes, Scorer<S> scorer, FieldInfoMap fieldInfos, TranslationContext context) {
        JExpression valueExpr;
        OperableRef operableRef;
        Predicate predicate = node.requirePredicate();
        if (predicate instanceof SimplePredicate) {
            SimplePredicate simplePredicate = (SimplePredicate)predicate;
            operableRef = TreeModelTranslator.ensureOperable(simplePredicate, dependentNodes, fieldInfos, context);
            SimplePredicate.Operator operator = simplePredicate.requireOperator();
            switch (operator) {
                case IS_MISSING: {
                    return TreeModelTranslator.createBranch(operableRef.isMissing(), context);
                }
                case IS_NOT_MISSING: {
                    return TreeModelTranslator.createBranch(operableRef.isNotMissing(), context);
                }
            }
            Object value = simplePredicate.requireValue();
            switch (operator) {
                case EQUAL: {
                    valueExpr = operableRef.equalTo(value, context);
                    break;
                }
                case NOT_EQUAL: {
                    valueExpr = operableRef.notEqualTo(value, context);
                    break;
                }
                case LESS_THAN: {
                    valueExpr = operableRef.lessThan(value, context);
                    break;
                }
                case LESS_OR_EQUAL: {
                    valueExpr = operableRef.lessOrEqual(value, context);
                    break;
                }
                case GREATER_OR_EQUAL: {
                    valueExpr = operableRef.greaterOrEqual(value, context);
                    break;
                }
                case GREATER_THAN: {
                    valueExpr = operableRef.greaterThan(value, context);
                    break;
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)predicate, (Enum)operator);
                }
            }
        } else if (predicate instanceof SimpleSetPredicate) {
            SimpleSetPredicate simpleSetPredicate = (SimpleSetPredicate)predicate;
            operableRef = TreeModelTranslator.ensureOperable(simpleSetPredicate, dependentNodes, fieldInfos, context);
            ComplexArray complexArray = (ComplexArray)simpleSetPredicate.requireArray();
            Collection values = complexArray.getValue();
            SimpleSetPredicate.BooleanOperator booleanOperator = simpleSetPredicate.requireBooleanOperator();
            switch (booleanOperator) {
                case IS_IN: {
                    valueExpr = operableRef.isIn(values, context);
                    break;
                }
                case IS_NOT_IN: {
                    valueExpr = operableRef.isNotIn(values, context);
                    break;
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)predicate, (Enum)booleanOperator);
                }
            }
        } else {
            if (predicate instanceof True) {
                return TreeModelTranslator.createBranch(JExpr.TRUE, context);
            }
            if (predicate instanceof False) {
                return TreeModelTranslator.createBranch(JExpr.FALSE, context);
            }
            throw new UnsupportedElementException((PMMLObject)predicate);
        }
        boolean isNonMissing = context.isNonMissing(operableRef);
        TreeModel.MissingValueStrategy missingValueStrategy = treeModel.getMissingValueStrategy();
        switch (missingValueStrategy) {
            case NONE: {
                if (!isNonMissing && operableRef.requiresNotMissingCheck()) {
                    valueExpr = operableRef.isNotMissing().cand(valueExpr);
                }
                NodeScope result = TreeModelTranslator.createBranch(valueExpr, context);
                if (!isNonMissing) {
                    result.markNonMissing(operableRef);
                }
                return result;
            }
            case NULL_PREDICTION: {
                if (!isNonMissing) {
                    scorer.yieldIf(operableRef.isMissing(), null, context);
                    context.markNonMissing(operableRef);
                }
                return TreeModelTranslator.createBranch(valueExpr, context);
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum)missingValueStrategy);
    }

    public static FieldInfoMap enhanceFieldInfos(Set<? extends PMMLObject> bodyObjects, FieldInfoMap fieldInfos, ArrayInfoMap arrayInfos) {
        CountingActiveFieldFinder countingActiveFieldFinder = new CountingActiveFieldFinder();
        DiscreteValueFinder discreteValueFinder = new DiscreteValueFinder();
        for (PMMLObject pMMLObject : bodyObjects) {
            Node node = (Node)pMMLObject;
            countingActiveFieldFinder.applyTo(node);
            discreteValueFinder.applyTo((Visitable)node);
        }
        Map<String, Set<Object>> discreteFieldValues = discreteValueFinder.getFieldValues();
        HashMap hashMap = new HashMap();
        HashMap fieldArrayInfos = new HashMap();
        arrayInfos.values().stream().forEach(arrayInfo -> {
            List<Integer> indices = arrayInfo.getIndices();
            BiMap<Integer, DataField> dataFields = arrayInfo.getDataFields();
            int min = Collections.min(indices);
            int max = Collections.max(indices);
            ArrayList<DataField> elements = new ArrayList<DataField>(max + 1);
            for (int i = 0; i <= max; ++i) {
                elements.add((DataField)dataFields.get(i));
            }
            arrayInfoElements.put(arrayInfo, elements);
            dataFields.values().stream().forEach(dataField -> fieldArrayInfos.put((Field<?>)dataField, (ArrayInfo)arrayInfo));
        });
        ArrayListMultimap tfTokens = ArrayListMultimap.create();
        Set entries = fieldInfos.entrySet();
        block8: for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            FieldInfo fieldInfo = (FieldInfo)entry.getValue();
            Field<?> field = fieldInfo.getField();
            DataType dataType = field.requireDataType();
            OpType opType = field.requireOpType();
            fieldInfo.updateCount(countingActiveFieldFinder.getCount(name));
            block0 : switch (opType) {
                case CONTINUOUS: {
                    switch (dataType) {
                        case INTEGER: 
                        case FLOAT: 
                        case DOUBLE: {
                            FpPrimitiveEncoder encoder = FpPrimitiveEncoder.create(fieldInfo, fieldArrayInfos);
                            if (encoder instanceof ArrayFpPrimitiveEncoder) {
                                ArrayFpPrimitiveEncoder arrayFpPrimitiveEncoder = (ArrayFpPrimitiveEncoder)encoder;
                                ArrayInfo arrayInfo2 = arrayFpPrimitiveEncoder.getArrayInfo();
                                List elements = (List)hashMap.get(arrayInfo2);
                                arrayFpPrimitiveEncoder.setElements(elements);
                            } else if (encoder instanceof TermFrequencyEncoder) {
                                TermFrequencyEncoder termFrequencyEncoder = (TermFrequencyEncoder)encoder;
                                FunctionInvocation.Tf tf = termFrequencyEncoder.getTf(fieldInfo);
                                List tokens = tfTokens.get((Object)tf.getTextField());
                                int index = tokens.indexOf(tf.getTermTokens());
                                if (index < 0) {
                                    index = tokens.size();
                                    tokens.add(tf.getTermTokens());
                                }
                                termFrequencyEncoder.setIndex(index).setVocabulary(tokens);
                            } else if (dataType == DataType.INTEGER) {
                                encoder = null;
                            }
                            fieldInfo.setEncoder(encoder);
                            break block0;
                        }
                    }
                    break;
                }
                case CATEGORICAL: {
                    Set<Object> values = discreteFieldValues.get(name);
                    if (values == null || values.isEmpty()) continue block8;
                    OrdinalEncoder encoder = OrdinalEncoder.create(fieldInfo, values);
                    fieldInfo.setEncoder(encoder);
                    break;
                }
            }
        }
        return fieldInfos;
    }

    public static void ensureTextIndexFields(FieldInfo fieldInfo, TermFrequencyEncoder encoder, TranslationContext context) {
        JDefinedClass owner = context.getOwner(JavaModel.class);
        FunctionInvocation.Tf tf = encoder.getTf(fieldInfo);
        TextIndex textIndex = tf.getTextIndex();
        String name = tf.getTextField();
        String textIndexName = IdentifierUtil.create("textIndex", (PMMLObject)textIndex, name);
        JFieldVar textIndexVar = (JFieldVar)owner.fields().get(textIndexName);
        if (textIndexVar == null) {
            JBinaryFileInitializer resourceInitializer = new JBinaryFileInitializer(IdentifierUtil.create(TextIndex.class.getSimpleName(), (PMMLObject)textIndex) + ".data", context);
            TextIndex localTextIndex = TextIndexUtil.toLocalTextIndex(textIndex, name);
            textIndexVar = owner.field(28, (JType)context.ref(TextIndex.class), textIndexName, (JExpression)PMMLObjectUtil.createObject((PMMLObject)localTextIndex, context));
            TokenizedString[] terms = (TokenizedString[])encoder.getVocabulary().stream().toArray(TokenizedString[]::new);
            JFieldVar jFieldVar = resourceInitializer.initTokenizedStringLists(IdentifierUtil.create("terms", (PMMLObject)textIndex, name), terms);
        }
    }

    private static OperableRef ensureOperable(final HasFieldReference<?> hasFieldReference, final List<Node> dependentNodes, FieldInfoMap fieldInfos, TranslationContext context) {
        FieldInfo fieldInfo = fieldInfos.require(hasFieldReference);
        Function<JMethod, Boolean> function = new Function<JMethod, Boolean>(){

            @Override
            public Boolean apply(JMethod method) {
                JType type = method.type();
                if (type.isReference()) {
                    return true;
                }
                return TreeModelTranslator.usesField(dependentNodes, hasFieldReference.requireField());
            }
        };
        return context.ensureOperable(fieldInfo, function);
    }

    private static ValueMapBuilder createScoreDistribution(Object[] categories, JVar scoreVar, TranslationContext context) {
        ValueMapBuilder valueMapBuilder = new ValueMapBuilder(context).construct("values");
        ValueFactoryRef valueFactoryRef = context.getValueFactoryVariable();
        for (int i = 0; i < categories.length; ++i) {
            JInvocation valueExpr = valueFactoryRef.newValue((JExpression)scoreVar.component(JExpr.lit((int)i)));
            valueMapBuilder.update("put", categories[i], valueExpr);
        }
        return valueMapBuilder;
    }

    private static NodeScope createBranch(JExpression testExpr, TranslationContext context) {
        NodeScope scope = (NodeScope)context.ensureOpenScope();
        JBlock block = scope.getBlock();
        JIfStatement ifStatement = new JIfStatement(testExpr);
        block.add((JStatement)ifStatement);
        return new NodeScope(ifStatement);
    }

    private static List<Node> collectDependentNodes(Node node, List<Node> siblings) {
        if (node.hasNodes()) {
            List children = node.getNodes();
            if (!siblings.isEmpty()) {
                return Streams.concat((Stream[])new Stream[]{children.stream(), siblings.stream()}).collect(Collectors.toList());
            }
            return children;
        }
        return siblings;
    }

    private static boolean usesField(Collection<Node> nodes, String fieldName) {
        for (Node node : nodes) {
            if (!TreeModelTranslator.usesField(node, fieldName)) continue;
            return true;
        }
        return false;
    }

    private static boolean usesField(Node node, String fieldName) {
        HasFieldReference hasFieldReference;
        Predicate predicate = node.requirePredicate();
        if (predicate instanceof HasFieldReference && Objects.equals((hasFieldReference = (HasFieldReference)predicate).requireField(), fieldName)) {
            return true;
        }
        if (node.hasNodes()) {
            return TreeModelTranslator.usesField(node.getNodes(), fieldName);
        }
        return false;
    }
}

