/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.translator;

import com.sun.codemodel.JArray;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JForLoop;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JGenerable;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JResourceFile;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.codemodel.fmt.JBinaryFile;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jpmml.evaluator.ResourceUtil;
import org.jpmml.evaluator.TokenizedString;
import org.jpmml.translator.JResourceInitializer;
import org.jpmml.translator.TranslationContext;

public class JBinaryFileInitializer
extends JResourceInitializer {
    private JBinaryFile binaryFile = null;
    private JVar dataInputVar = null;
    private JBlock tryBody = new JBlock();
    private JVar ioeVar = null;
    private JBlock catchBody = new JBlock();

    public JBinaryFileInitializer(String name, TranslationContext context) {
        this(name, -1, context);
    }

    public JBinaryFileInitializer(String name, int pos, TranslationContext context) {
        super(context);
        JDefinedClass owner;
        JBinaryFile binaryFile = new JBinaryFile(name);
        this.setBinaryFile(binaryFile);
        try {
            owner = JBinaryFileInitializer.getResourceOwner(context);
        }
        catch (IllegalArgumentException iae) {
            owner = context.getOwner();
        }
        JPackage _package = owner.getPackage();
        _package.addResourceFile((JResourceFile)binaryFile);
        JBlock resourceStmt = new JBlock(false, false);
        JClass dataInputStreamClazz = context.ref(DataInputStream.class);
        JInvocation isExpr = JExpr.dotclass((JClass)owner).invoke("getResourceAsStream").arg(name);
        this.dataInputVar = resourceStmt.decl((JType)dataInputStreamClazz, "dataInput", (JExpression)context._new(dataInputStreamClazz, isExpr));
        JBlock catchStmt = new JBlock(false, false);
        this.ioeVar = catchStmt.decl((JType)context.ref(IOException.class), "ioe");
        this.catchBody._throw((JExpression)context._new(ExceptionInInitializerError.class, this.ioeVar));
        JStatement tryWithResources = new JStatement(){

            public void state(JFormatter formatter) {
                formatter.p("try(").b(JBinaryFileInitializer.this.dataInputVar).p(")");
                formatter.g((JGenerable)JBinaryFileInitializer.this.tryBody);
                formatter.p("catch(").b(JBinaryFileInitializer.this.ioeVar).p(")");
                formatter.g((JGenerable)JBinaryFileInitializer.this.catchBody);
                formatter.nl();
            }
        };
        JBlock init = owner.init();
        if (pos > -1) {
            init.pos(pos);
        }
        init.add(tryWithResources);
    }

    @Override
    public void add(JStatement statement) {
        this.tryBody.add(statement);
    }

    @Override
    public void assign(JVar variable, JExpression expr) {
        this.tryBody.assign((JAssignmentTarget)variable, expr);
    }

    @Override
    public JInvocation initQNames(QName[] names) {
        TranslationContext context = this.getContext();
        JBinaryFile binaryFile = this.getBinaryFile();
        try (OutputStream os = binaryFile.getDataStore();){
            DataOutputStream dataOutput = new DataOutputStream(os);
            ResourceUtil.writeQNames((DataOutput)dataOutput, (QName[])names);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return context.staticInvoke(ResourceUtil.class, "readQNames", this.dataInputVar, names.length);
    }

    @Override
    public JInvocation initValues(JType type, Object[] values) {
        String readMethod;
        TranslationContext context = this.getContext();
        JBinaryFile binaryFile = this.getBinaryFile();
        try (OutputStream os = binaryFile.getDataStore();){
            DataOutputStream dataOutput = new DataOutputStream(os);
            readMethod = this.recordValues(dataOutput, type, values);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        JInvocation invocation = context.staticInvoke(ResourceUtil.class, readMethod, this.dataInputVar, values.length);
        return invocation;
    }

    @Override
    public JInvocation initTokenizedStringLists(TokenizedString[] tokenizedStrings) {
        TranslationContext context = this.getContext();
        JBinaryFile binaryFile = this.getBinaryFile();
        try (OutputStream os = binaryFile.getDataStore();){
            DataOutputStream dataOutput = new DataOutputStream(os);
            ResourceUtil.writeTokenizedStrings((DataOutput)dataOutput, (TokenizedString[])tokenizedStrings);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        JInvocation invocation = context.staticInvoke(ResourceUtil.class, "readTokenizedStrings", this.dataInputVar, tokenizedStrings.length);
        return context.staticInvoke(Arrays.class, "asList", new Object[0]).arg((JExpression)invocation);
    }

    @Override
    public JInvocation initNumbers(JType type, Number[] values) {
        String readMethod;
        TranslationContext context = this.getContext();
        JBinaryFile binaryFile = this.getBinaryFile();
        try (OutputStream os = binaryFile.getDataStore();){
            DataOutputStream dataOutput = new DataOutputStream(os);
            readMethod = this.recordValues(dataOutput, type, values);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        JInvocation invocation = context.staticInvoke(ResourceUtil.class, readMethod, this.dataInputVar, values.length);
        return context.staticInvoke(Arrays.class, "asList", new Object[0]).arg((JExpression)invocation);
    }

    @Override
    public JInvocation initNumbersList(JType type, List<Number[]> elements) {
        TranslationContext context = this.getContext();
        JBinaryFile binaryFile = this.getBinaryFile();
        String readMethod = null;
        JArray countArray = JExpr.newArray((JType)context._ref(Integer.TYPE));
        try (OutputStream os = binaryFile.getDataStore();){
            DataOutputStream dataOutput = new DataOutputStream(os);
            for (Object[] objectArray : elements) {
                readMethod = this.recordValues(dataOutput, type.elementType(), objectArray);
                countArray.add(JExpr.lit((int)objectArray.length));
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        JMethod readNumbersListMethod = JBinaryFileInitializer.ensureReadNumbersListMethod(type, readMethod, context);
        return JExpr.invoke((JMethod)readNumbersListMethod).arg((JExpression)this.dataInputVar).arg((JExpression)countArray);
    }

    @Override
    public JInvocation initNumberArraysList(JType type, List<Number[][]> elements, int length) {
        TranslationContext context = this.getContext();
        JBinaryFile binaryFile = this.getBinaryFile();
        String readArraysMethod = null;
        JArray countArray = JExpr.newArray((JType)context._ref(Integer.TYPE));
        try (OutputStream os = binaryFile.getDataStore();){
            DataOutputStream dataOutput = new DataOutputStream(os);
            for (Number[][] element : elements) {
                readArraysMethod = this.recordArrayValues(dataOutput, type.elementType(), element);
                countArray.add(JExpr.lit((int)element.length));
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        JMethod readNumberArraysListMethod = JBinaryFileInitializer.ensureReadNumberArraysListMethod(type, readArraysMethod, context);
        return JExpr.invoke((JMethod)readNumberArraysListMethod).arg((JExpression)this.dataInputVar).arg((JExpression)countArray).arg(JExpr.lit((int)length));
    }

    @Override
    public JInvocation initNumbersMap(JType keyType, JType valueType, Map<?, Number> map) {
        String valueReadMethod;
        String keyReadMethod;
        TranslationContext context = this.getContext();
        JBinaryFile binaryFile = this.getBinaryFile();
        Set<?> keys = map.keySet();
        Collection<Number> values = map.values();
        Class<?> keysClazz = JBinaryFileInitializer.getValueClass(keys);
        Class<?> valuesClazz = JBinaryFileInitializer.getValueClass(values, Number.class);
        try (OutputStream os = binaryFile.getDataStore();){
            DataOutputStream dataOutput = new DataOutputStream(os);
            keyReadMethod = this.recordValues(dataOutput, keyType, JBinaryFileInitializer.toArray(keys, keysClazz));
            valueReadMethod = this.recordValues(dataOutput, valueType, JBinaryFileInitializer.toArray(values, valuesClazz));
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        JMethod readNumbersMapMethod = JBinaryFileInitializer.ensureReadNumbersMapMethod(keyType, valueType, keyReadMethod, valueReadMethod, context);
        return JExpr.invoke((JMethod)readNumbersMapMethod).arg((JExpression)this.dataInputVar).arg(JExpr.lit((int)map.size()));
    }

    private String recordValues(DataOutput dataOutput, JType type, Object[] values) throws IOException {
        String typeName;
        switch (typeName = type.fullName()) {
            case "java.lang.String": {
                ResourceUtil.writeStrings((DataOutput)dataOutput, (String[])JBinaryFileInitializer.castArray(values, new String[values.length]));
                return "readStrings";
            }
            case "java.lang.Integer": {
                ResourceUtil.writeIntegers((DataOutput)dataOutput, (Number[])JBinaryFileInitializer.castArray(values, new Integer[values.length]));
                return "readIntegers";
            }
            case "java.lang.Float": {
                ResourceUtil.writeFloats((DataOutput)dataOutput, (Number[])JBinaryFileInitializer.castArray(values, new Float[values.length]));
                return "readFloats";
            }
            case "java.lang.Double": {
                ResourceUtil.writeDoubles((DataOutput)dataOutput, (Number[])JBinaryFileInitializer.castArray(values, new Double[values.length]));
                return "readDoubles";
            }
        }
        throw new IllegalArgumentException(typeName);
    }

    private String recordArrayValues(DataOutput dataOutput, JType type, Number[][] values) throws IOException {
        String typeName;
        switch (typeName = type.fullName()) {
            case "java.lang.Float[]": {
                ResourceUtil.writeFloatArrays((DataOutput)dataOutput, (Number[][])values);
                return "readFloatArrays";
            }
            case "java.lang.Double[]": {
                ResourceUtil.writeDoubleArrays((DataOutput)dataOutput, (Number[][])values);
                return "readDoubleArrays";
            }
        }
        throw new IllegalArgumentException(typeName);
    }

    public JBinaryFile getBinaryFile() {
        return this.binaryFile;
    }

    private void setBinaryFile(JBinaryFile binaryFile) {
        this.binaryFile = binaryFile;
    }

    private static <E> E[] toArray(Collection<?> values, Class<? extends E> clazz) {
        return values.toArray(size -> (Object[])Array.newInstance(clazz, size));
    }

    private static <E> E[] castArray(Object[] values, E[] newValues) {
        return Arrays.asList(values).toArray(newValues);
    }

    private static JMethod ensureReadNumbersListMethod(JType type, String readMethod, TranslationContext context) {
        JDefinedClass owner = JBinaryFileInitializer.getResourceOwner(context);
        String name = readMethod + "List";
        JClass dataInputClazz = context.ref(DataInput.class);
        JType intClazz = context._ref(Integer.TYPE);
        JClass intArrayClazz = intClazz.array();
        JMethod method = owner.getMethod(name, new JType[]{dataInputClazz, intArrayClazz});
        if (method == null) {
            method = owner.method(28, (JType)context.genericRef(List.class, type), name)._throws(IOException.class);
            JVar dataInputParam = method.param((JType)dataInputClazz, "dataInput");
            JVar countsParam = method.param((JType)intArrayClazz, "counts");
            JBlock block = method.body();
            JVar resultVar = block.decl(method.type(), "result", (JExpression)context._new(ArrayList.class, new Object[0]));
            JForEach forEach = block.forEach(intClazz, "count", (JExpression)countsParam);
            JInvocation invocation = context.staticInvoke(ResourceUtil.class, readMethod, dataInputParam, forEach.var());
            forEach.body().add((JStatement)resultVar.invoke("add").arg((JExpression)invocation));
            block._return((JExpression)resultVar);
        }
        return method;
    }

    private static JMethod ensureReadNumberArraysListMethod(JType type, String readArraysMethod, TranslationContext context) {
        JDefinedClass owner = JBinaryFileInitializer.getResourceOwner(context);
        String name = readArraysMethod + "List";
        JClass dataInputClazz = context.ref(DataInput.class);
        JType intClazz = context._ref(Integer.TYPE);
        JClass intArrayClazz = intClazz.array();
        JMethod method = owner.getMethod(name, new JType[]{dataInputClazz, intArrayClazz, intClazz});
        if (method == null) {
            method = owner.method(28, (JType)context.genericRef(List.class, type), name)._throws(IOException.class);
            JVar dataInputParam = method.param(DataInput.class, "dataInput");
            JVar countsParam = method.param((JType)intArrayClazz, "counts");
            JVar lengthParam = method.param(intClazz, "length");
            JBlock block = method.body();
            JVar resultVar = block.decl(method.type(), "result", (JExpression)context._new(ArrayList.class, new Object[0]));
            JForEach forEach = block.forEach(intClazz, "count", (JExpression)countsParam);
            JInvocation invocation = context.staticInvoke(ResourceUtil.class, readArraysMethod, dataInputParam, forEach.var(), lengthParam);
            forEach.body().add((JStatement)resultVar.invoke("add").arg((JExpression)invocation));
            block._return((JExpression)resultVar);
        }
        return method;
    }

    private static JMethod ensureReadNumbersMapMethod(JType keyType, JType valueType, String keyReadMethod, String valueReadMethod, TranslationContext context) {
        JDefinedClass owner = JBinaryFileInitializer.getResourceOwner(context);
        String name = keyReadMethod + valueReadMethod.replace("read", "") + "Map";
        JClass dataInputClazz = context.ref(DataInput.class);
        JType intClazz = context._ref(Integer.TYPE);
        JMethod method = owner.getMethod(name, new JType[]{dataInputClazz, intClazz});
        if (method == null) {
            method = owner.method(28, (JType)context.genericRef(Map.class, keyType, valueType), name)._throws(IOException.class);
            JVar dataInputParam = method.param(DataInput.class, "dataInput");
            JVar sizeParam = method.param(intClazz, "size");
            JBlock block = method.body();
            JVar resultVar = block.decl(method.type(), "result", (JExpression)context._new(LinkedHashMap.class, new Object[0]));
            JInvocation keysInvocation = context.staticInvoke(ResourceUtil.class, keyReadMethod, dataInputParam, sizeParam);
            JInvocation valuesInvocation = context.staticInvoke(ResourceUtil.class, valueReadMethod, dataInputParam, sizeParam);
            JVar keysVar = block.decl((JType)keyType.array(), "keys", (JExpression)keysInvocation);
            JVar valuesVar = block.decl((JType)valueType.array(), "values", (JExpression)valuesInvocation);
            JForLoop forLoop = block._for();
            JVar loopVar = forLoop.init(intClazz, "i", JExpr.lit((int)0));
            forLoop.test(loopVar.lt((JExpression)sizeParam));
            forLoop.update(loopVar.incr());
            JBlock forBlock = forLoop.body();
            forBlock.add((JStatement)JExpr.invoke((JExpression)resultVar, (String)"put").arg((JExpression)keysVar.component((JExpression)loopVar)).arg((JExpression)valuesVar.component((JExpression)loopVar)));
            block._return((JExpression)resultVar);
        }
        return method;
    }
}

