/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.transpiler;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JResourceFile;
import com.sun.codemodel.JType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.jar.Manifest;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitable;
import org.jpmml.codemodel.ArchiverUtil;
import org.jpmml.codemodel.CompilerUtil;
import org.jpmml.codemodel.JServiceConfigurationFile;
import org.jpmml.codemodel.JarCodeWriter;
import org.jpmml.codemodel.MarkedCodeWriter;
import org.jpmml.translator.PMMLObjectUtil;
import org.jpmml.translator.TranslationContext;
import org.jpmml.translator.visitors.ModelTranslatorVisitorBattery;

public class TranspilerUtil {
    private static final String HEADER;

    private TranspilerUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JCodeModel translate(PMML pmml, String className) {
        ModelTranslatorVisitorBattery visitorBattery = new ModelTranslatorVisitorBattery();
        visitorBattery.applyTo((Visitable)pmml);
        JCodeModel codeModel = new JCodeModel();
        TranslationContext context = new TranslationContext(pmml, codeModel);
        JDefinedClass transpiledPmmlClazz = PMMLObjectUtil.createClass((PMMLObject)pmml, className, context);
        try {
            context.pushOwner(transpiledPmmlClazz);
            PMMLObjectUtil.createDefaultConstructor((PMMLObject)pmml, context);
        }
        finally {
            context.popOwner();
        }
        JPackage servicePackage = codeModel._package("META-INF/services");
        servicePackage.addResourceFile((JResourceFile)new JServiceConfigurationFile((JType)context.ref(PMML.class), Collections.singletonList(transpiledPmmlClazz)));
        return codeModel;
    }

    public static void compile(JCodeModel codeModel) throws IOException {
        TranspilerUtil.compile(codeModel, System.out);
    }

    public static void compile(JCodeModel codeModel, final PrintStream diagnosticStream) throws IOException {
        DiagnosticListener<JavaFileObject> diagnosticListener = null;
        if (diagnosticStream != null) {
            diagnosticListener = new DiagnosticListener<JavaFileObject>(){

                @Override
                public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                    SimpleJavaFileObject source = (SimpleJavaFileObject)diagnostic.getSource();
                    long lineNumber = diagnostic.getLineNumber();
                    Diagnostic.Kind kind = diagnostic.getKind();
                    String message = diagnostic.getMessage(null);
                    diagnosticStream.println((String)(source != null ? source.getName() + ":" + lineNumber + ": " : "") + kind.name().toLowerCase() + ": " + message);
                }
            };
        }
        CompilerUtil.compile((JCodeModel)codeModel, null, (DiagnosticListener)diagnosticListener, null);
    }

    public static void archive(JCodeModel codeModel, OutputStream os) throws IOException {
        Manifest manifest = ArchiverUtil.createManifest(TranspilerUtil.class);
        MarkedCodeWriter codeWriter = new MarkedCodeWriter((CodeWriter)new JarCodeWriter(os, manifest), HEADER);
        codeModel.build((CodeWriter)codeWriter);
    }

    static {
        String[] lines = new String[]{"/*", " * Copyright (c) 2022 Villu Ruusmann", " *", " * This file is part of JPMML-Evaluator", " *", " * JPMML-Evaluator is free software: you can redistribute it and/or modify", " * it under the terms of the GNU Affero General Public License as published by", " * the Free Software Foundation, either version 3 of the License, or", " * (at your option) any later version.", " *", " * JPMML-Evaluator is distributed in the hope that it will be useful,", " * but WITHOUT ANY WARRANTY; without even the implied warranty of", " * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the", " * GNU Affero General Public License for more details.", " *", " * You should have received a copy of the GNU Affero General Public License", " * along with JPMML-Evaluator.  If not, see <http://www.gnu.org/licenses/>.", " */"};
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line).append(System.lineSeparator());
        }
        HEADER = sb.toString();
    }
}

