/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost.example;

import com.beust.jcommander.DefaultUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.constant.Constable;
import java.nio.ByteOrder;
import java.util.LinkedHashMap;
import java.util.List;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.jpmml.model.metro.MetroJAXBSerializer;
import org.jpmml.xgboost.ByteOrderUtil;
import org.jpmml.xgboost.FeatureMap;
import org.jpmml.xgboost.Learner;
import org.jpmml.xgboost.XGBoostUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    @Parameter(names={"--model-input"}, description="XGBoost model input file", required=true, order=1)
    private File modelInput = null;
    @Parameter(names={"--fmap-input"}, description="XGBoost feature map input file", order=2)
    private File fmapInput = null;
    @Parameter(names={"--pmml-output"}, description="PMML output file", required=true, order=3)
    private File pmmlOutput = null;
    @Parameter(names={"--byte_order"}, description="Endianness of XGBoost model input file. Possible values \"BIG_ENDIAN\" (\"BE\") or \"LITTLE_ENDIAN\" (\"LE\")", order=4)
    private String byteOrder = ByteOrder.nativeOrder().toString();
    @Parameter(names={"--charset"}, description="Charset of XGBoost model input file", order=5)
    private String charset = null;
    @Parameter(names={"--json-path"}, description="JSONPath expression of the JSON model element", order=6)
    private String jsonPath = "$";
    @Parameter(names={"--target-name"}, description="Target name. Defaults to \"_target\"", order=7)
    private String targetName = null;
    @Parameter(names={"--target-categories"}, description="Target categories. Defaults to 0-based index [0, 1, .., num_class - 1]", order=8)
    private List<String> targetCategories = null;
    @Parameter(names={"--X-missing"}, description="Missing value. Defaults to Not-a-Number (NaN) value", order=9)
    private Float missing = Float.valueOf(Float.NaN);
    @Parameter(names={"--X-compact"}, description="Transform XGBoost-style trees to PMML-style trees", arity=1, order=10)
    private boolean compact = true;
    @Parameter(names={"--X-input_float"}, description="Allow field data type updates", arity=1, order=11)
    private Boolean inputFloat = null;
    @Parameter(names={"--X-numeric"}, description="Simplify non-numeric split conditions to numeric split conditions", arity=1, order=12)
    private boolean numeric = true;
    @Parameter(names={"--X-prune"}, description="Remove unreachable nodes", arity=1, order=13)
    private boolean prune = true;
    @Parameter(names={"--X-ntree_limit"}, description="Limit the number of trees. Defaults to all trees", order=14)
    private Integer ntreeLimit = null;
    @Parameter(names={"--help"}, description="Show the list of configuration options and exit", help=true, order=0x7FFFFFFF)
    private boolean help = false;
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = new JCommander((Object)main);
        commander.setProgramName(Main.class.getName());
        DefaultUsageFormatter usageFormatter = new DefaultUsageFormatter(commander);
        try {
            commander.parse(args);
        }
        catch (ParameterException pe) {
            StringBuilder sb = new StringBuilder();
            sb.append(pe.toString());
            sb.append("\n");
            usageFormatter.usage(sb);
            System.err.println(sb.toString());
            System.exit(-1);
        }
        if (main.help) {
            StringBuilder sb = new StringBuilder();
            usageFormatter.usage(sb);
            System.out.println(sb.toString());
            System.exit(0);
        }
        main.run();
    }

    private void run() throws Exception {
        PMML pmml;
        Learner learner;
        ByteOrder byteOrder = ByteOrderUtil.forValue((String)this.byteOrder);
        try (FileInputStream is = new FileInputStream(this.modelInput);){
            logger.info("Parsing learner..");
            long begin = System.currentTimeMillis();
            learner = XGBoostUtil.loadLearner((InputStream)is, (ByteOrder)byteOrder, (String)this.charset, (String)this.jsonPath);
            long end = System.currentTimeMillis();
            logger.info("Parsed learner in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to parse learner", (Throwable)e);
            throw e;
        }
        FeatureMap featureMap = null;
        if (this.fmapInput != null) {
            try (FileInputStream is = new FileInputStream(this.fmapInput);){
                logger.info("Parsing feature map..");
                long begin = System.currentTimeMillis();
                featureMap = XGBoostUtil.loadFeatureMap((InputStream)is);
                long end = System.currentTimeMillis();
                logger.info("Parsed feature map in {} ms.", (Object)(end - begin));
            }
            catch (Exception e) {
                logger.error("Failed to parse feature map", (Throwable)e);
                throw e;
            }
        }
        LinkedHashMap<String, Constable> options = new LinkedHashMap<String, Constable>();
        options.put("missing", this.missing);
        options.put("compact", Boolean.valueOf(this.compact));
        options.put("input_float", this.inputFloat);
        options.put("numeric", Boolean.valueOf(this.numeric));
        options.put("prune", Boolean.valueOf(this.prune));
        options.put("ntree_limit", this.ntreeLimit);
        try {
            logger.info("Converting learner to PMML..");
            long begin = System.currentTimeMillis();
            pmml = learner.encodePMML(options, this.targetName, this.targetCategories, featureMap);
            long end = System.currentTimeMillis();
            logger.info("Converted learner to PMML in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to convert learner to PMML", (Throwable)e);
            throw e;
        }
        try (FileOutputStream os = new FileOutputStream(this.pmmlOutput);){
            logger.info("Marshalling PMML..");
            MetroJAXBSerializer jaxbSerializer = new MetroJAXBSerializer();
            long begin = System.currentTimeMillis();
            jaxbSerializer.serializePretty((PMMLObject)pmml, (OutputStream)os);
            long end = System.currentTimeMillis();
            logger.info("Marshalled PMML in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to marshal PMML", (Throwable)e);
            throw e;
        }
    }
}

