/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Value;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;

public class FeatureMap {
    private List<Entry> entries = new ArrayList<Entry>();
    private Map<Value.Property, List<String>> valueMap = new EnumMap<Value.Property, List<String>>(Value.Property.class);

    /*
     * WARNING - void declaration
     */
    public List<Feature> encodeFeatures(PMMLEncoder encoder) {
        ArrayList<Feature> result = new ArrayList<Feature>();
        LinkedHashSet<void> dataFields = new LinkedHashSet<void>();
        List<Entry> entries = this.getEntries();
        for (Entry entry : entries) {
            ContinuousFeature feature;
            void var9_9;
            String name = entry.getName();
            String value = entry.getValue();
            DataField dataField = encoder.getDataField(name);
            if (dataField == null) {
                Entry.Type type = entry.getType();
                switch (type) {
                    case BINARY_INDICATOR: {
                        DataField dataField2 = encoder.createDataField(name, OpType.CATEGORICAL, DataType.STRING);
                        break;
                    }
                    case FLOAT: {
                        DataField dataField3 = encoder.createDataField(name, OpType.CONTINUOUS, DataType.FLOAT);
                        break;
                    }
                    case INTEGER: {
                        DataField dataField4 = encoder.createDataField(name, OpType.CONTINUOUS, DataType.INTEGER);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.valueOf((Object)type));
                    }
                }
            }
            if (value != null) {
                PMMLUtil.addValues((Field)var9_9, Collections.singletonList(value));
            }
            dataFields.add(var9_9);
            OpType opType = var9_9.requireOpType();
            switch (opType) {
                case CATEGORICAL: {
                    feature = new BinaryFeature(encoder, (Field)var9_9, (Object)value);
                    break;
                }
                case CONTINUOUS: {
                    feature = new ContinuousFeature(encoder, (Field)var9_9);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Expected categorical or continuous operational type, got " + opType.value() + " operational type");
                }
            }
            result.add((Feature)feature);
        }
        Set<Map.Entry<Value.Property, List<String>>> valueEntries = this.valueMap.entrySet();
        for (DataField dataField : dataFields) {
            for (Map.Entry entry : valueEntries) {
                PMMLUtil.addValues((Field)dataField, (Value.Property)((Value.Property)entry.getKey()), (List)((List)entry.getValue()));
            }
        }
        return result;
    }

    public void addEntry(String name, String type) {
        String value = null;
        if ("i".equals(type)) {
            int equals = name.indexOf(61);
            if (equals < 0) {
                throw new IllegalArgumentException(name);
            }
            value = name.substring(equals + 1);
            name = name.substring(0, equals);
        }
        Entry entry = new Entry(name, value, Entry.Type.fromString(type));
        this.addEntry(entry);
    }

    public void addEntry(Entry entry) {
        List<Entry> entries = this.getEntries();
        entries.add(entry);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void addValidValue(String value) {
        this.addValue(Value.Property.VALID, value);
    }

    public void addInvalidValue(String value) {
        this.addValue(Value.Property.INVALID, value);
    }

    public void addMissingValue(String value) {
        this.addValue(Value.Property.MISSING, value);
    }

    private void addValue(Value.Property property, String value) {
        if (value == null) {
            return;
        }
        List<String> values = this.valueMap.get(property);
        if (values == null) {
            values = new ArrayList<String>();
            this.valueMap.put(property, values);
        }
        values.add(value);
    }

    public static class Entry {
        private String name = null;
        private String value = null;
        private Type type = null;

        public Entry(String name, String value, Type type) {
            this.setName(name);
            this.setValue(value);
            this.setType(type);
        }

        public String getName() {
            return this.name;
        }

        private void setName(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public String getValue() {
            return this.value;
        }

        private void setValue(String value) {
            this.value = value;
        }

        public Type getType() {
            return this.type;
        }

        private void setType(Type type) {
            this.type = Objects.requireNonNull(type);
        }

        public static enum Type {
            BINARY_INDICATOR,
            FLOAT,
            INTEGER;


            public static Type fromString(String string) {
                switch (string) {
                    case "i": {
                        return BINARY_INDICATOR;
                    }
                    case "q": {
                        return FLOAT;
                    }
                    case "int": {
                        return INTEGER;
                    }
                }
                throw new IllegalArgumentException(string);
            }
        }
    }
}

