/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost.testing;

import com.google.common.base.Equivalence;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.dmg.pmml.Header;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Timestamp;
import org.jpmml.evaluator.ResultField;
import org.jpmml.evaluator.testing.IntegrationTestBatch;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.xgboost.FeatureMap;
import org.jpmml.xgboost.Learner;
import org.jpmml.xgboost.XGBoostUtil;
import org.jpmml.xgboost.testing.XGBoostTest;

public abstract class XGBoostTestBatch
extends IntegrationTestBatch {
    private String format = System.getProperty(XGBoostTestBatch.class.getName() + ".format", "model,json");

    public XGBoostTestBatch(String name, String dataset, Predicate<ResultField> predicate, Equivalence<Object> equivalence) {
        super(name, dataset, predicate, equivalence);
    }

    public abstract XGBoostTest getIntegrationTest();

    public Map<String, Object> getOptions() {
        String[] dataset = this.parseDataset();
        Integer ntreeLimit = null;
        if (dataset.length > 1) {
            ntreeLimit = new Integer(dataset[1]);
        }
        LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
        options.put("compact", ntreeLimit != null);
        options.put("prune", true);
        options.put("nan_as_missing", true);
        options.put("ntree_limit", ntreeLimit);
        return options;
    }

    public PMML getPMML() throws Exception {
        String[] extensions;
        PMML result = null;
        String[] dataset = this.parseDataset();
        for (String extension : extensions = this.format.split(",")) {
            String learnerPath = "/xgboost/" + this.getName() + dataset[0] + "." + extension;
            String featureMapPath = "/csv/" + dataset[0] + ".fmap";
            PMML pmml = this.loadPMML(learnerPath, featureMapPath);
            if (result != null) {
                this.assertEquals(result, pmml);
            }
            result = pmml;
        }
        return result;
    }

    public List<Map<String, String>> getInput() throws IOException {
        String[] dataset = this.parseDataset();
        return this.loadRecords("/csv/" + dataset[0] + ".csv");
    }

    public List<Map<String, String>> getOutput() throws IOException {
        return this.loadRecords("/csv/" + this.getName() + this.getDataset() + ".csv");
    }

    protected PMML loadPMML(String learnerPath, String featureMapPath) throws Exception {
        FeatureMap featureMap;
        Learner learner;
        try (InputStream is = this.open(learnerPath);){
            learner = XGBoostUtil.loadLearner(is);
        }
        try (InputStream is = this.open(featureMapPath);){
            featureMap = XGBoostUtil.loadFeatureMap(is);
        }
        Map<String, Object> options = this.getOptions();
        PMML pmml = learner.encodePMML(options, null, null, featureMap);
        this.validatePMML(pmml);
        return pmml;
    }

    protected String[] parseDataset() {
        String dataset = this.getDataset();
        int index = dataset.indexOf(64);
        if (index > -1) {
            return new String[]{dataset.substring(0, index), dataset.substring(index + 1)};
        }
        return new String[]{dataset};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertEquals(PMML left, PMML right) {
        Header leftHeader = left.requireHeader();
        Header rightHeader = right.requireHeader();
        Timestamp leftTimestamp = leftHeader.getTimestamp();
        Timestamp rightTimestamp = rightHeader.getTimestamp();
        try {
            leftHeader.setTimestamp(null);
            rightHeader.setTimestamp(null);
            boolean equals = ReflectionUtil.equals((PMMLObject)left, (PMMLObject)right);
            if (!equals) {
                throw new AssertionError();
            }
        }
        finally {
            leftHeader.setTimestamp(leftTimestamp);
            rightHeader.setTimestamp(rightTimestamp);
        }
    }
}

