/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost.visitors;

import java.util.List;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.visitors.AbstractTreeModelTransformer;

public class TreeModelCompactor
extends AbstractTreeModelTransformer {
    public void enterNode(Node node) {
        Object id = node.getId();
        Object score = node.getScore();
        Object defaultChild = node.getDefaultChild();
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (node.hasNodes()) {
            List children = node.getNodes();
            if (children.size() != 2 || score != null || defaultChild == null) {
                throw new IllegalArgumentException();
            }
            Node firstChild = (Node)children.get(0);
            Node secondChild = (Node)children.get(1);
            Predicate firstPredicate = firstChild.requirePredicate();
            Predicate secondPredicate = secondChild.requirePredicate();
            TreeModelCompactor.checkFieldReference((Predicate)firstPredicate, (Predicate)secondPredicate);
            if (!(firstPredicate instanceof SimplePredicate) || !(secondPredicate instanceof SimplePredicate)) {
                throw new IllegalArgumentException();
            }
            TreeModelCompactor.checkValue((Predicate)firstPredicate, (Predicate)secondPredicate);
            if (TreeModelCompactor.equalsNode((Object)defaultChild, (Node)firstChild)) {
                children = TreeModelCompactor.swapChildren((Node)node);
                firstChild = (Node)children.get(0);
                secondChild = (Node)children.get(1);
            } else if (!TreeModelCompactor.equalsNode((Object)defaultChild, (Node)secondChild)) {
                throw new IllegalArgumentException();
            }
            node.setDefaultChild(null);
            secondChild.setPredicate((Predicate)True.INSTANCE);
        } else if (score == null || defaultChild != null) {
            throw new IllegalArgumentException();
        }
        node.setId(null);
    }

    public void exitNode(Node node) {
        Predicate predicate = node.requirePredicate();
        if (predicate instanceof True) {
            Node parentNode = this.getParentNode();
            if (parentNode == null) {
                return;
            }
            TreeModelCompactor.initScore((Node)parentNode, (Node)node);
            TreeModelCompactor.replaceChildWithGrandchildren((Node)parentNode, (Node)node);
        }
    }

    public void enterTreeModel(TreeModel treeModel) {
        TreeModel.MissingValueStrategy missingValueStrategy = treeModel.getMissingValueStrategy();
        TreeModel.NoTrueChildStrategy noTrueChildStrategy = treeModel.getNoTrueChildStrategy();
        TreeModel.SplitCharacteristic splitCharacteristic = treeModel.getSplitCharacteristic();
        if (missingValueStrategy != TreeModel.MissingValueStrategy.DEFAULT_CHILD || noTrueChildStrategy != TreeModel.NoTrueChildStrategy.RETURN_NULL_PREDICTION || splitCharacteristic != TreeModel.SplitCharacteristic.BINARY_SPLIT) {
            throw new IllegalArgumentException();
        }
    }

    public void exitTreeModel(TreeModel treeModel) {
        treeModel.setMissingValueStrategy(TreeModel.MissingValueStrategy.NONE).setNoTrueChildStrategy(TreeModel.NoTrueChildStrategy.RETURN_LAST_PREDICTION).setSplitCharacteristic(TreeModel.SplitCharacteristic.MULTI_SPLIT);
    }
}

