/*
 * Copyright (c) 2025 Villu Ruusmann
 */
package org.jpmml.telemetry;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;

import com.google.gson.Gson;

public class TelemetryClient {

	static
	public String report(String restServiceUrl, Incident incident) throws IOException, InterruptedException {
		Gson gson = new Gson();

		String requestJson = gson.toJson(incident);

		HttpClient httpClient = HttpClient.newHttpClient();

		HttpRequest postRequest = HttpRequest.newBuilder()
			.uri(URI.create(restServiceUrl))
			.header("Content-Type", "application/json")
			.POST(HttpRequest.BodyPublishers.ofString(requestJson))
			.build();

		HttpResponse<String> postResponse = httpClient.send(postRequest, HttpResponse.BodyHandlers.ofString());

		int status = postResponse.statusCode();
		if(status != 201){
			throw new IOException();
		}

		String responseJson = postResponse.body();

		Map<String, Object> response = gson.fromJson(responseJson, Map.class);

		return (String)response.get("message");
	}
}