/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xjc;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CValuePropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.xml.sax.ErrorHandler;

public class ValueConstructorPlugin
extends AbstractParameterizablePlugin {
    private boolean ignoreAttributes = false;
    private boolean ignoreElements = false;
    private boolean ignoreValues = false;

    public String getOptionName() {
        return "XvalueConstructor";
    }

    public String getUsage() {
        return null;
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        Collection clazzes = outline.getClasses();
        for (ClassOutline clazz : clazzes) {
            JVar param;
            List<JFieldVar> superClassFields = this.getSuperClassFields(clazz);
            List<JFieldVar> classFields = this.getClassFields(clazz);
            if (superClassFields.size() <= 0 && classFields.size() <= 0) continue;
            JMethod defaultConstructor = clazz.implClass.constructor(1);
            JInvocation defaultSuperInvocation = defaultConstructor.body().invoke("super");
            defaultConstructor.annotate(Deprecated.class);
            JMethod valueConstructor = clazz.implClass.constructor(1);
            JInvocation valueSuperInvocation = valueConstructor.body().invoke("super");
            for (JFieldVar superClassField : superClassFields) {
                param = valueConstructor.param(8, superClassField.type(), superClassField.name());
                valueSuperInvocation.arg((JExpression)param);
            }
            for (JFieldVar classField : classFields) {
                param = valueConstructor.param(8, classField.type(), classField.name());
                valueConstructor.body().assign((JAssignmentTarget)JExpr.refthis((String)param.name()), (JExpression)param);
            }
        }
        return true;
    }

    private List<JFieldVar> getSuperClassFields(ClassOutline clazz) {
        ArrayList<JFieldVar> result = new ArrayList<JFieldVar>();
        for (ClassOutline superClazz = clazz.getSuperClass(); superClazz != null; superClazz = superClazz.getSuperClass()) {
            result.addAll(0, this.getValueFields(superClazz));
        }
        return result;
    }

    private List<JFieldVar> getClassFields(ClassOutline clazz) {
        return this.getValueFields(clazz);
    }

    private List<JFieldVar> getValueFields(ClassOutline clazz) {
        FieldOutline[] fields;
        ArrayList<JFieldVar> result = new ArrayList<JFieldVar>();
        for (FieldOutline field : fields = clazz.getDeclaredFields()) {
            CElementPropertyInfo elementPropertyInfo;
            CAttributePropertyInfo attributePropertyInfo;
            JFieldVar fieldVar;
            CPropertyInfo propertyInfo = field.getPropertyInfo();
            if (propertyInfo.isCollection() || ((fieldVar = (JFieldVar)clazz.implClass.fields().get(propertyInfo.getName(false))).mods().getValue() & 0x10) == 16) continue;
            if (propertyInfo instanceof CAttributePropertyInfo && !this.getIgnoreAttributes() && (attributePropertyInfo = (CAttributePropertyInfo)propertyInfo).isRequired()) {
                result.add(fieldVar);
            }
            if (propertyInfo instanceof CElementPropertyInfo && !this.getIgnoreElements() && (elementPropertyInfo = (CElementPropertyInfo)propertyInfo).isRequired()) {
                result.add(fieldVar);
            }
            if (!(propertyInfo instanceof CValuePropertyInfo) || this.getIgnoreValues()) continue;
            result.add(fieldVar);
        }
        return result;
    }

    public boolean getIgnoreAttributes() {
        return this.ignoreAttributes;
    }

    public void setIgnoreAttributes(boolean ignoreAttributes) {
        this.ignoreAttributes = ignoreAttributes;
    }

    public boolean getIgnoreElements() {
        return this.ignoreElements;
    }

    public void setIgnoreElements(boolean ignoreElements) {
        this.ignoreElements = ignoreElements;
    }

    public boolean getIgnoreValues() {
        return this.ignoreValues;
    }

    public void setIgnoreValues(boolean ignoreValues) {
        this.ignoreValues = ignoreValues;
    }
}

