/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xjc;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JJavaName;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Collection;
import java.util.List;
import org.jpmml.xjc.CodeModelUtil;
import org.xml.sax.ErrorHandler;

public class PMMLPlugin
extends Plugin {
    public String getOptionName() {
        return "Xpmml";
    }

    public String getUsage() {
        return null;
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        super.postProcessModel(model, errorHandler);
        Collection classInfos = model.beans().values();
        for (CClassInfo classInfo : classInfos) {
            List propertyInfos = classInfo.getProperties();
            for (CPropertyInfo propertyInfo : propertyInfos) {
                String publicName = propertyInfo.getName(true);
                String privateName = propertyInfo.getName(false);
                if (propertyInfo.isCollection()) {
                    if (privateName.contains("And") || privateName.contains("Or") || privateName.equalsIgnoreCase("content")) {
                        propertyInfo.setName(true, "Content");
                        propertyInfo.setName(false, "content");
                        continue;
                    }
                    if (privateName.endsWith("array") || privateName.endsWith("Array")) {
                        publicName = publicName + "s";
                        privateName = privateName + "s";
                    } else if (privateName.endsWith("ref") || privateName.endsWith("Ref")) {
                        publicName = publicName + "s";
                        privateName = privateName + "s";
                    } else {
                        publicName = JJavaName.getPluralForm((String)publicName);
                        privateName = JJavaName.getPluralForm((String)privateName);
                    }
                    propertyInfo.setName(true, publicName);
                    propertyInfo.setName(false, privateName);
                    continue;
                }
                if (!privateName.equals("isScorable")) continue;
                propertyInfo.setName(true, "Scorable");
                propertyInfo.setName(false, "scorable");
            }
        }
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        Model model = outline.getModel();
        JCodeModel codeModel = model.codeModel;
        JClass hasIdInterface = codeModel.ref("org.dmg.pmml.HasId");
        JClass hasExtensionsInterface = codeModel.ref("org.dmg.pmml.HasExtensions");
        JClass iterableInterface = codeModel.ref("java.lang.Iterable");
        JClass iteratorInterface = codeModel.ref("java.util.Iterator");
        Collection clazzes = outline.getClasses();
        for (ClassOutline clazz : clazzes) {
            FieldOutline[] fields;
            FieldOutline contentField;
            FieldOutline extensionsField;
            JDefinedClass definedClazz = clazz.implClass;
            FieldOutline idField = PMMLPlugin.getIdField(clazz);
            if (idField != null) {
                definedClazz._implements(hasIdInterface);
            }
            if ((extensionsField = PMMLPlugin.getExtensionsField(clazz)) != null) {
                definedClazz._implements(hasExtensionsInterface);
            }
            if ((contentField = PMMLPlugin.getContentField(clazz)) != null) {
                CPropertyInfo propertyInfo = contentField.getPropertyInfo();
                JFieldVar fieldVar = CodeModelUtil.getFieldVar(contentField);
                JType elementType = CodeModelUtil.getElementType(fieldVar.type());
                definedClazz._implements(iterableInterface.narrow(elementType));
                JMethod iteratorMethod = definedClazz.method(1, (JType)iteratorInterface.narrow(elementType), "iterator");
                iteratorMethod.body()._return((JExpression)JExpr.invoke((String)("get" + propertyInfo.getName(true))).invoke("iterator"));
            }
            for (FieldOutline field : fields = clazz.getDeclaredFields()) {
                CPropertyInfo propertyInfo = field.getPropertyInfo();
                if (!propertyInfo.isCollection()) continue;
                JFieldRef fieldRef = JExpr.refthis((String)propertyInfo.getName(false));
                JMethod hasElementsMethod = definedClazz.method(1, Boolean.TYPE, "has" + propertyInfo.getName(true));
                hasElementsMethod.body()._return(fieldRef.ne(JExpr._null()).cand(fieldRef.invoke("size").gt(JExpr.lit((int)0))));
            }
        }
        return true;
    }

    private static FieldOutline getIdField(ClassOutline clazz) {
        FieldOutline[] fields;
        String name = "id";
        for (FieldOutline field : fields = clazz.getDeclaredFields()) {
            CPropertyInfo propertyInfo = field.getPropertyInfo();
            String privateName = propertyInfo.getName(false);
            JType fieldType = field.getRawType();
            if (!name.equals(privateName) || !"java.lang.String".equals(fieldType.fullName())) continue;
            return field;
        }
        return null;
    }

    private static FieldOutline getExtensionsField(ClassOutline clazz) {
        FieldOutline[] fields;
        String name = "extensions";
        for (FieldOutline field : fields = clazz.getDeclaredFields()) {
            JType elementType;
            CPropertyInfo propertyInfo = field.getPropertyInfo();
            String privateName = propertyInfo.getName(false);
            JType fieldType = field.getRawType();
            if (!name.equals(privateName) || !propertyInfo.isCollection() || !"org.dmg.pmml.Extension".equals((elementType = CodeModelUtil.getElementType(fieldType)).fullName())) continue;
            return field;
        }
        return null;
    }

    private static FieldOutline getContentField(ClassOutline clazz) {
        FieldOutline[] fields;
        String name = clazz.implClass.name();
        for (FieldOutline field : fields = clazz.getDeclaredFields()) {
            JType elementType;
            String elementName;
            CPropertyInfo propertyInfo = field.getPropertyInfo();
            JType fieldType = field.getRawType();
            if (!propertyInfo.isCollection() || !name.equals((elementName = (elementType = CodeModelUtil.getElementType(fieldType)).name()) + "s") && !name.equals(JJavaName.getPluralForm((String)elementName))) continue;
            return field;
        }
        return null;
    }
}

