/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.jmxremote;

import java.io.IOException;
import java.net.ConnectException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import org.jppf.JPPFException;
import org.jppf.comm.interceptor.InterceptorHandler;
import org.jppf.comm.socket.SocketChannelClient;
import org.jppf.comm.socket.SocketInitializer;
import org.jppf.comm.socket.SocketWrapper;
import org.jppf.jmx.JMXEnvHelper;
import org.jppf.jmx.JPPFJMXProperties;
import org.jppf.jmxremote.JPPFMBeanServerConnection;
import org.jppf.jmxremote.message.JMXMessageHandler;
import org.jppf.jmxremote.message.JMXNotification;
import org.jppf.jmxremote.nio.ChannelsPair;
import org.jppf.jmxremote.nio.JMXNioServer;
import org.jppf.jmxremote.nio.JMXNioServerPool;
import org.jppf.jmxremote.notification.ClientListenerInfo;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFIdentifiers;
import org.jppf.utils.configuration.JPPFProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFJMXConnector
implements JMXConnector {
    private static final Logger log = LoggerFactory.getLogger(JPPFJMXConnector.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final Map<String, Object> environment;
    private final JMXServiceURL address;
    private boolean secure = false;
    private JPPFMBeanServerConnection mbsc;
    private String connectionID;
    private final List<ConnectionListenerInfo> connectionListeners = new CopyOnWriteArrayList<ConnectionListenerInfo>();
    private final AtomicInteger notificationSequence = new AtomicInteger(0);
    private final Map<Integer, ClientListenerInfo> notificationListenerMap = new HashMap<Integer, ClientListenerInfo>();
    private JMXMessageHandler messageHandler;

    public JPPFJMXConnector(JMXServiceURL serviceURL, Map<String, ?> environment) {
        this.environment = environment == null ? new HashMap<String, Object>() : new HashMap(environment);
        this.address = serviceURL;
        if (debugEnabled) {
            log.debug("initialized JPPFJMXConnector with serviceURL = {} and environment = {}", (Object)this.address, this.environment);
        }
    }

    @Override
    public void connect() throws IOException {
        this.connect(null);
    }

    @Override
    public void connect(Map<String, ?> env) throws IOException {
        Boolean tls;
        if (debugEnabled) {
            log.debug("env = {}, this.environment={}", env, this.environment);
        }
        if (env != null) {
            this.environment.putAll(env);
        }
        String s = JMXEnvHelper.getString((JPPFProperty)JPPFJMXProperties.TLS_ENABLED, this.environment, null);
        if (debugEnabled) {
            log.debug("secure='{}'", (Object)s);
        }
        this.secure = (tls = Boolean.valueOf(s)) == null ? false : tls;
        try {
            this.init();
            this.fireConnectionNotification(false, null);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.mbsc;
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(Subject delegationSubject) throws IOException {
        return this.mbsc;
    }

    @Override
    public void close() throws IOException {
        this.mbsc.close();
    }

    @Override
    public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        if (listener == null) {
            return;
        }
        this.connectionListeners.add(new ConnectionListenerInfo(listener, filter, handback));
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (listener == null) {
            return;
        }
        ArrayList<ConnectionListenerInfo> toRemove = new ArrayList<ConnectionListenerInfo>(this.connectionListeners.size());
        for (ConnectionListenerInfo info : this.connectionListeners) {
            if (info.listener != listener) continue;
            toRemove.add(info);
        }
        if (toRemove.isEmpty()) {
            throw new ListenerNotFoundException("could not find any matching listener");
        }
        this.connectionListeners.removeAll(toRemove);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (listener == null) {
            return;
        }
        ConnectionListenerInfo toRemove = null;
        for (ConnectionListenerInfo info : this.connectionListeners) {
            if (info.listener != listener || info.filter != filter || info.handback != handback) continue;
            toRemove = info;
            break;
        }
        if (toRemove == null) {
            throw new ListenerNotFoundException("could not find any matching listener");
        }
        this.connectionListeners.remove(toRemove);
    }

    private void fireConnectionNotification(boolean isClose, Exception exception) {
        if (debugEnabled) {
            log.debug("isClose={}, exception={}", (Object)isClose, (Object)exception);
        }
        String type = isClose ? (exception == null ? "jmx.remote.connection.closed" : "jmx.remote.connection.failed") : "jmx.remote.connection.opened";
        if (debugEnabled) {
            log.debug("firing notif with type={}, exception={}, connectionID={}", new Object[]{type, ExceptionUtils.getMessage((Throwable)exception), this.connectionID});
        }
        JMXConnectionNotification notif = new JMXConnectionNotification(type, this, this.connectionID, this.notificationSequence.incrementAndGet(), null, null);
        for (ConnectionListenerInfo info : this.connectionListeners) {
            if (info.filter != null && !info.filter.isNotificationEnabled(notif)) continue;
            info.listener.handleNotification(notif, info.handback);
        }
    }

    @Override
    public String getConnectionId() throws IOException {
        return this.connectionID;
    }

    public Map<String, ?> getEnvironment() {
        return this.environment;
    }

    public JMXServiceURL getAddress() {
        return this.address;
    }

    JMXMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    private void init() throws Exception {
        SocketInitializer socketInitializer;
        SocketChannelClient socketClient = new SocketChannelClient(this.address.getHost(), this.address.getPort(), true);
        if (debugEnabled) {
            log.debug("Attempting connection to remote peer at {}", (Object)this.address);
        }
        if (!(socketInitializer = SocketInitializer.Factory.newInstance()).initialize((SocketWrapper)socketClient)) {
            Exception e = socketInitializer.getLastException();
            throw e == null ? new ConnectException("could not connect to remote JMX server " + this.address) : e;
        }
        if (!InterceptorHandler.invokeOnConnect((SocketChannel)socketClient.getChannel())) {
            throw new JPPFException("connection denied by interceptor");
        }
        if (debugEnabled) {
            log.debug("Connected to JMX server {}, sending channel identifier {}", (Object)this.address, (Object)JPPFIdentifiers.serverName((int)65528));
        }
        socketClient.writeInt(65528);
        if (debugEnabled) {
            log.debug("Reconnected to JMX server {}, secure={}", (Object)this.address, (Object)this.secure);
        }
        JMXNioServer server = JMXNioServerPool.getServer();
        ChannelsPair pair = server.createChannelsPair(this.environment, "", -1, socketClient.getChannel(), this.secure, true);
        pair.addCloseCallback(new ChannelsPair.CloseCallback(){

            @Override
            public void onClose(Exception exception) {
                JPPFJMXConnector.this.fireConnectionNotification(true, exception);
            }
        });
        this.messageHandler = pair.getMessageHandler();
        if (debugEnabled) {
            log.debug("registering channel");
        }
        server.registerChannel(pair, socketClient.getChannel());
        if (debugEnabled) {
            log.debug("getting connection id");
        }
        this.connectionID = (String)this.messageHandler.sendRequestWithResponse((byte)1, this.environment.get("jmx.remote.credentials"));
        pair.setConnectionID(this.connectionID);
        if (debugEnabled) {
            log.debug("received connectionId = {}", (Object)this.connectionID);
        }
        this.mbsc = new JPPFMBeanServerConnection(this);
        pair.setJMXConnector(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(JMXNotification jmxNotification) throws Exception {
        if (debugEnabled) {
            log.debug("received notification {}", (Object)jmxNotification);
        }
        ArrayList<ClientListenerInfo> infos = new ArrayList<ClientListenerInfo>(jmxNotification.getListenerIDs().length);
        Map<Integer, ClientListenerInfo> map = this.notificationListenerMap;
        synchronized (map) {
            Integer[] integerArray = jmxNotification.getListenerIDs();
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Integer listenerID = integerArray[n2];
                ClientListenerInfo info = this.notificationListenerMap.get(listenerID);
                if (info != null) {
                    infos.add(info);
                }
                ++n2;
            }
        }
        for (ClientListenerInfo info : infos) {
            info.getListener().handleNotification(jmxNotification.getNotification(), info.getHandback());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws Exception {
        int listenerID = (Integer)this.messageHandler.sendRequestWithResponse((byte)3, name, filter);
        Map<Integer, ClientListenerInfo> map = this.notificationListenerMap;
        synchronized (map) {
            this.notificationListenerMap.put(listenerID, new ClientListenerInfo(listenerID, name, listener, filter, handback));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNotificationListener(ObjectName name, NotificationListener listener) throws Exception {
        ArrayList<ClientListenerInfo> toRemove = new ArrayList<ClientListenerInfo>();
        Map<Integer, ClientListenerInfo> map = this.notificationListenerMap;
        synchronized (map) {
            for (Map.Entry<Integer, ClientListenerInfo> entry : this.notificationListenerMap.entrySet()) {
                ClientListenerInfo info = entry.getValue();
                if (!info.getMbeanName().equals(name) || info.getListener() != listener) continue;
                toRemove.add(info);
            }
            if (toRemove.isEmpty()) {
                throw new ListenerNotFoundException("no matching listener");
            }
            int[] ids = new int[toRemove.size()];
            int i = 0;
            while (i < ids.length) {
                ids[i] = ((ClientListenerInfo)toRemove.get(i)).getListenerID();
                ++i;
            }
            this.messageHandler.sendRequestWithResponse((byte)21, name, ids);
            int[] nArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                this.notificationListenerMap.remove(id);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws Exception {
        ClientListenerInfo toRemove = null;
        Map<Integer, ClientListenerInfo> map = this.notificationListenerMap;
        synchronized (map) {
            for (Map.Entry<Integer, ClientListenerInfo> entry : this.notificationListenerMap.entrySet()) {
                ClientListenerInfo info = entry.getValue();
                if (!info.getMbeanName().equals(name) || info.getListener() != listener || info.getFilter() != filter || info.getHandback() != handback) continue;
                toRemove = info;
                break;
            }
            if (toRemove == null) {
                throw new ListenerNotFoundException("no matching listener");
            }
            this.messageHandler.sendRequestWithResponse((byte)22, name, toRemove.getListenerID());
            this.notificationListenerMap.remove(toRemove.getListenerID());
        }
    }

    private static final class ConnectionListenerInfo {
        private final NotificationListener listener;
        private final NotificationFilter filter;
        private final Object handback;

        private ConnectionListenerInfo(NotificationListener listener, NotificationFilter filter, Object handback) {
            this.listener = listener;
            this.filter = filter;
            this.handback = handback;
        }
    }
}

