/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.jmxremote.protocol.jppf;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorProvider;
import javax.management.remote.JMXServiceURL;
import org.jppf.jmx.ClientEnvironmentProvider;
import org.jppf.jmx.EnvironmentProviderHandler;
import org.jppf.jmxremote.JPPFJMXConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientProvider
implements JMXConnectorProvider {
    private static Logger log = LoggerFactory.getLogger(ClientProvider.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static final EnvironmentProviderHandler<ClientEnvironmentProvider> ENV_HANDLER = new EnvironmentProviderHandler(ClientEnvironmentProvider.class);

    @Override
    public JMXConnector newJMXConnector(JMXServiceURL serviceURL, Map<String, ?> environment) throws IOException {
        if (!"jppf".equals(serviceURL.getProtocol())) {
            throw new MalformedURLException("Protocol not jppf: " + serviceURL.getProtocol());
        }
        if (debugEnabled) {
            log.debug("creating JPPFJMXConnector with serviceUrl = {}, env = {}", (Object)serviceURL, environment);
        }
        HashMap env = new HashMap(environment);
        for (ClientEnvironmentProvider provider : ENV_HANDLER.getProviders()) {
            Map map;
            if (provider == null || (map = provider.getEnvironment()) == null || map.isEmpty()) continue;
            env.putAll(map);
        }
        return new JPPFJMXConnector(serviceURL, env);
    }
}

