/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.jmxremote.nio;

import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.JMException;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import org.jppf.jmxremote.JMXAuthorizationChecker;
import org.jppf.jmxremote.JPPFJMXConnector;
import org.jppf.jmxremote.JPPFJMXConnectorServer;
import org.jppf.jmxremote.message.JMXMessageHandler;
import org.jppf.jmxremote.nio.JMXContext;
import org.jppf.jmxremote.nio.JMXNioServer;
import org.jppf.jmxremote.nio.JMXTransitionTask;
import org.jppf.nio.CloseableContext;
import org.jppf.nio.NioChannelHandler;
import org.jppf.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelsPair
extends Pair<JMXContext, JMXContext>
implements NioChannelHandler,
CloseableContext {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ChannelsPair.class);
    private final AtomicBoolean closing = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private String connectionID;
    private boolean serverSide;
    private JPPFJMXConnectorServer jxmConnectorServer;
    private JPPFJMXConnector jmxConnector;
    private int serverPort = -1;
    private final JMXTransitionTask writingTask;
    private final JMXTransitionTask nonSelectingWritingTask;
    private int interestOps;
    private SelectionKey selectionKey;
    private JMXMessageHandler messageHandler;
    private final List<CloseCallback> closeCallbacks = new CopyOnWriteArrayList<CloseCallback>();
    private final JMXAuthenticator authenticator;
    private JMXAuthorizationChecker auhtorizationChecker;
    private Subject subject;

    public ChannelsPair(JMXContext first, JMXContext second, JMXNioServer server, JMXAuthenticator authenticator) {
        super((Object)first, (Object)second);
        this.authenticator = authenticator;
        this.writingTask = new JMXTransitionTask(second, server, true);
        this.nonSelectingWritingTask = new JMXTransitionTask(second, server, false);
    }

    public JMXContext readingContext() {
        return (JMXContext)((Object)this.first());
    }

    public JMXContext writingContext() {
        return (JMXContext)((Object)this.second());
    }

    /*
     * Unable to fully structure code
     */
    public void close(Exception exception) throws Exception {
        try {
            if (this.closed.compareAndSet(false, true)) {
                this.getSelectionKey().channel().close();
            }
        }
        finally {
            tmp = new ArrayList<CloseCallback>(this.closeCallbacks);
            this.closeCallbacks.clear();
            var5_6 = tmp.iterator();
            if (true) ** GOTO lbl16
        }
        {
        }
        do {
            runnable = (CloseCallback)var5_6.next();
            runnable.onClose(exception);
lbl16:
            // 2 sources

        } while (var5_6.hasNext());
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void setClosed(boolean closed) {
    }

    public void requestClose() {
        this.closing.set(true);
    }

    public boolean isClosing() {
        return this.closing.get();
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public ChannelsPair setConnectionID(String connectionID) {
        this.connectionID = connectionID;
        return this;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public void setServerSide(boolean serverSide) {
        this.serverSide = serverSide;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public JPPFJMXConnectorServer getJxmConnectorServer() {
        return this.jxmConnectorServer;
    }

    public void setJxmConnectorServer(JPPFJMXConnectorServer connectorServer) {
        this.jxmConnectorServer = connectorServer;
    }

    public JPPFJMXConnector getJMXConnector() {
        return this.jmxConnector;
    }

    public void setJMXConnector(JPPFJMXConnector mbeanServerConnection) {
        this.jmxConnector = mbeanServerConnection;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + '[' + "readingChannelID=" + this.readingContext().getId() + ", writingChannelID=" + this.writingContext().getId() + ", connectionID=" + this.connectionID + ", closed=" + this.closed.get() + ", closing=" + this.closing.get() + ", serverSide=" + this.serverSide + ", socketChannel=" + (this.selectionKey == null ? "null" : this.selectionKey.channel()) + ']';
    }

    public JMXTransitionTask getWritingTask() {
        return this.writingTask;
    }

    public JMXTransitionTask getNonSelectingWritingTask() {
        return this.nonSelectingWritingTask;
    }

    public int getInterestOps() {
        return this.interestOps;
    }

    public void setInterestOps(int interestOps) {
        this.interestOps = interestOps;
    }

    public SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    public void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
    }

    public JMXMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(JMXMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void addCloseCallback(CloseCallback callback) {
        if (callback != null) {
            this.closeCallbacks.add(callback);
        }
    }

    public void removeCloseCallback(CloseCallback callback) {
        if (callback != null) {
            this.closeCallbacks.remove(callback);
        }
    }

    JMXAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    Subject getSubject() {
        return this.subject;
    }

    void setSubject(Subject subject) {
        this.subject = subject;
    }

    JMXAuthorizationChecker getAuhtorizationChecker() {
        return this.auhtorizationChecker;
    }

    void setAuhtorizationChecker(Object checker) {
        if (checker == null) {
            return;
        }
        try {
            Class<?> c = null;
            if (checker instanceof Class) {
                c = (Class<?>)checker;
            } else if (checker instanceof String) {
                c = Class.forName((String)checker, false, Thread.currentThread().getContextClassLoader());
            } else {
                throw new JMException("unable to interpret authorization checker parameter " + checker);
            }
            this.auhtorizationChecker = (JMXAuthorizationChecker)c.newInstance();
        }
        catch (Exception e) {
            log.error("error setting the authorization checker, ACL disabled for this connection", (Throwable)e);
        }
    }

    public static interface CloseCallback {
        public void onClose(Exception var1);
    }
}

