/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.jmxremote;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import org.jppf.jmxremote.JMXConnectionStatusEvent;
import org.jppf.jmxremote.JMXConnectionStatusListener;
import org.jppf.jmxremote.nio.JMXNioServer;
import org.jppf.jmxremote.nio.JMXNioServerPool;
import org.jppf.nio.NioHelper;
import org.jppf.utils.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFJMXConnectorServer
extends JMXConnectorServer
implements JMXConnectionStatusListener {
    private static Logger log = LoggerFactory.getLogger(JPPFJMXConnectorServer.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    public static final String AUTHORIZATION_CHECKER = "jmx.remote.x.authorization.checker";
    public static final String MBEAN_SERVER_KEY = "jppf.jmxremote.internal.mbeanserver";
    private final Map<String, Object> environment = new HashMap<String, Object>();
    private final JMXServiceURL address;
    private boolean started = false;

    public JPPFJMXConnectorServer(JMXServiceURL serviceURL, Map<String, ?> environment, MBeanServer mbeanServer) {
        super(mbeanServer);
        if (environment != null) {
            this.environment.putAll(environment);
        }
        this.environment.put(MBEAN_SERVER_KEY, mbeanServer);
        this.address = serviceURL;
    }

    @Override
    public void start() throws IOException {
        if (debugEnabled) {
            log.debug("starting server @{}, env={}", (Object)this.address, this.environment);
        }
        try {
            int port = this.address.getPort();
            Boolean tls = (Boolean)this.environment.get("jppf.jmx.remote.tls.enabled");
            boolean secure = tls == null ? false : tls;
            NioHelper.getAcceptorServer().addServer(port, secure, this.environment, false);
            if (debugEnabled) {
                log.debug("server @{} added listener port {}", (Object)this.address, (Object)port);
            }
            JMXNioServer[] jMXNioServerArray = JMXNioServerPool.getServers();
            int n = jMXNioServerArray.length;
            int n2 = 0;
            while (n2 < n) {
                JMXNioServer server = jMXNioServerArray[n2];
                server.addConnectionStatusListener(this);
                ++n2;
            }
            this.started = true;
            if (debugEnabled) {
                log.debug("successfully started server @{}", (Object)this.address);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void stop() throws IOException {
        try {
            if (!this.started) {
                return;
            }
            this.started = false;
            try {
                var4_1 = JMXNioServerPool.getServers();
                var3_2 = var4_1.length;
                var2_3 = 0;
                while (var2_3 < var3_2) {
                    server = var4_1[var2_3];
                    server.removeAllConnections(this.address.getPort());
                    ++var2_3;
                }
            }
            finally {
                var9_9 = JMXNioServerPool.getServers();
                var8_11 = var9_9.length;
                var7_13 = 0;
                ** while (var7_13 < var8_11)
            }
lbl-1000:
            // 1 sources

            {
                server = var9_9[var7_13];
                server.removeConnectionStatusListener(this);
                ++var7_13;
                continue;
lbl24:
                // 1 sources

            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean isActive() {
        return this.started;
    }

    @Override
    public JMXServiceURL getAddress() {
        return this.address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ?> getAttributes() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<String, Object> map2 = this.environment;
        synchronized (map2) {
            for (Map.Entry<String, Object> entry : this.environment.entrySet()) {
                if (!(entry.getValue() instanceof Serializable)) continue;
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public void connectionOpened(JMXConnectionStatusEvent event) {
        if (debugEnabled) {
            log.debug("server @{} connection opened event = {}", (Object)this.address, (Object)event);
        }
        this.connectionOpened(event.getConnectionID(), "connection opened", null);
    }

    @Override
    public void connectionClosed(JMXConnectionStatusEvent event) {
        if (debugEnabled) {
            log.debug("server @{} connection closed event = {}", (Object)this.address, (Object)event);
        }
        this.connectionClosed(event.getConnectionID(), "connection closed", null);
    }

    @Override
    public void connectionFailed(JMXConnectionStatusEvent event) {
        if (debugEnabled) {
            log.debug("server @{} connection failed event = {}", (Object)this.address, (Object)event);
        }
        this.connectionFailed(event.getConnectionID(), "connection failed", ExceptionUtils.getStackTrace((Throwable)event.getThrowable()));
    }
}

