/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.jmxremote.nio;

import org.jppf.JPPFError;
import org.jppf.jmxremote.nio.JMXNioServer;
import org.jppf.utils.JPPFConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXNioServerPool {
    private static final Logger log = LoggerFactory.getLogger(JMXNioServerPool.class);
    private static final int POOL_SIZE = JPPFConfiguration.getProperties().getInt("jppf.jmxremote.nio.servers.pool.size", 1);
    private static JMXNioServer[] servers = JMXNioServerPool.initialize();
    private static int currentIndex;
    private static boolean closed;

    private static JMXNioServer[] initialize() {
        JMXNioServer[] servers = new JMXNioServer[POOL_SIZE];
        try {
            int i = 0;
            while (i < POOL_SIZE) {
                servers[i] = new JMXNioServer();
                servers[i].start();
                ++i;
            }
        }
        catch (Exception e) {
            log.error("can't initialize JMX server pool", (Throwable)e);
            throw new JPPFError("can't initialize JMX server pool", (Throwable)e);
        }
        return servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JMXNioServer getServer() throws Exception {
        JMXNioServer[] jMXNioServerArray = servers;
        synchronized (servers) {
            JMXNioServer server = servers[currentIndex];
            currentIndex = (currentIndex + 1) % POOL_SIZE;
            // ** MonitorExit[var1] (shouldn't be in output)
            return server;
        }
    }

    public static void close() {
        if (!closed) {
            closed = true;
            if (servers != null) {
                JMXNioServer[] jMXNioServerArray = servers;
                int n = servers.length;
                int n2 = 0;
                while (n2 < n) {
                    JMXNioServer server = jMXNioServerArray[n2];
                    server.end();
                    ++n2;
                }
            }
        }
    }

    public static JMXNioServer[] getServers() throws Exception {
        return servers;
    }
}

