/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.jmxremote.nio;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import org.jppf.jmxremote.JMXAuthorizationChecker;
import org.jppf.jmxremote.message.JMXMessage;
import org.jppf.jmxremote.message.JMXNotification;
import org.jppf.jmxremote.message.JMXRequest;
import org.jppf.jmxremote.message.JMXResponse;
import org.jppf.jmxremote.nio.ChannelsPair;
import org.jppf.jmxremote.nio.JMXContext;
import org.jppf.jmxremote.nio.JMXNioServer;
import org.jppf.nio.SimpleNioMessage;
import org.jppf.nio.StateTransitionManager;
import org.jppf.utils.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JMXMessageReader {
    private static final Logger log = LoggerFactory.getLogger(JMXMessageReader.class);
    private static final boolean debugEnabled = log.isDebugEnabled();

    JMXMessageReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void read(JMXContext context) throws Exception {
        if (context.isSsl()) {
            SocketChannel socketChannel = context.getSocketChannel();
            synchronized (socketChannel) {
                JMXMessageReader.doRead(context);
            }
        } else {
            JMXMessageReader.doRead(context);
        }
    }

    private static void doRead(JMXContext context) throws Exception {
        StateTransitionManager mgr = context.getServer().getTransitionManager();
        while (true) {
            boolean b = false;
            try {
                b = context.readMessage(null);
            }
            catch (IOException e) {
                ChannelsPair pair = context.getChannels();
                if (pair.isClosed() || pair.isClosing()) {
                    return;
                }
                throw e;
            }
            if (b) {
                SimpleNioMessage message = (SimpleNioMessage)context.getMessage();
                if (debugEnabled) {
                    log.debug("read message from {}", (Object)context);
                }
                context.setMessage(null);
                mgr.execute((Runnable)new HandlingTask(context, message));
                continue;
            }
            if (context.byteCount <= 0L) break;
        }
    }

    private static void handleMessage(JMXContext context, SimpleNioMessage message) throws Exception {
        JMXMessage msg = context.deserializeMessage(message);
        if (debugEnabled) {
            log.debug("read message = {} from context = {}", (Object)msg, (Object)context);
        }
        if (msg instanceof JMXRequest) {
            JMXMessageReader.handleRequest(context, (JMXRequest)msg);
        } else if (msg instanceof JMXResponse) {
            JMXMessageReader.handleResponse(context, (JMXResponse)msg);
        } else if (msg instanceof JMXNotification) {
            JMXMessageReader.handleNotification(context, (JMXNotification)msg);
        }
    }

    private static void handleRequest(JMXContext context, JMXRequest request) throws Exception {
        if (debugEnabled) {
            log.debug("handling request = {} from {}", (Object)request, (Object)context);
        }
        boolean isException = false;
        Object result = null;
        Object[] p = request.getParams();
        MBeanServer mbs = context.getChannels().getMbeanServer();
        JMXNioServer jmxServer = context.getServer();
        try {
            JMXMessageReader.checkRequestAuthorization(context, request);
            switch (request.getMessageType()) {
                case 1: {
                    result = JMXMessageReader.handleConnect(context, request);
                    break;
                }
                case 2: {
                    JMXMessageReader.handleClose(context);
                    break;
                }
                case 16: {
                    result = mbs.invoke((ObjectName)p[0], (String)p[1], (Object[])p[2], (String[])p[3]);
                    break;
                }
                case 9: {
                    result = mbs.getAttribute((ObjectName)p[0], (String)p[1]);
                    break;
                }
                case 10: {
                    result = mbs.getAttributes((ObjectName)p[0], (String[])p[1]);
                    break;
                }
                case 25: {
                    mbs.setAttribute((ObjectName)p[0], (Attribute)p[1]);
                    break;
                }
                case 26: {
                    result = mbs.setAttributes((ObjectName)p[0], (AttributeList)p[1]);
                    break;
                }
                case 5: {
                    result = mbs.createMBean((String)p[0], (ObjectName)p[1]);
                    break;
                }
                case 6: {
                    result = mbs.createMBean((String)p[0], (ObjectName)p[1], (Object[])p[2], (String[])p[3]);
                    break;
                }
                case 7: {
                    result = mbs.createMBean((String)p[0], (ObjectName)p[1], (ObjectName)p[2]);
                    break;
                }
                case 8: {
                    result = mbs.createMBean((String)p[0], (ObjectName)p[1], (ObjectName)p[2], (Object[])p[3], (String[])p[4]);
                    break;
                }
                case 11: {
                    result = mbs.getDefaultDomain();
                    break;
                }
                case 12: {
                    result = mbs.getDomains();
                    break;
                }
                case 13: {
                    result = mbs.getMBeanCount();
                    break;
                }
                case 14: {
                    result = mbs.getMBeanInfo((ObjectName)p[0]);
                    break;
                }
                case 15: {
                    result = mbs.getObjectInstance((ObjectName)p[0]);
                    break;
                }
                case 17: {
                    result = mbs.isInstanceOf((ObjectName)p[0], (String)p[1]);
                    break;
                }
                case 18: {
                    result = mbs.isRegistered((ObjectName)p[0]);
                    break;
                }
                case 19: {
                    result = mbs.queryMBeans((ObjectName)p[0], (QueryExp)p[1]);
                    break;
                }
                case 20: {
                    result = mbs.queryNames((ObjectName)p[0], (QueryExp)p[1]);
                    break;
                }
                case 27: {
                    mbs.unregisterMBean((ObjectName)p[0]);
                    break;
                }
                case 3: {
                    result = jmxServer.getServerNotificationHandler().addNotificationListener(mbs, context.getConnectionID(), (ObjectName)p[0], (NotificationFilter)p[1]);
                    break;
                }
                case 4: {
                    mbs.addNotificationListener((ObjectName)p[0], (ObjectName)p[1], (NotificationFilter)p[2], p[3]);
                    break;
                }
                case 21: {
                    jmxServer.getServerNotificationHandler().removeNotificationListeners(mbs, (ObjectName)p[0], (int[])p[1]);
                    break;
                }
                case 22: {
                    jmxServer.getServerNotificationHandler().removeNotificationListeners(mbs, (ObjectName)p[0], new int[]{(Integer)p[1]});
                    break;
                }
                case 23: {
                    mbs.removeNotificationListener((ObjectName)p[0], (ObjectName)p[1]);
                    break;
                }
                case 24: {
                    mbs.removeNotificationListener((ObjectName)p[0], (ObjectName)p[1], (NotificationFilter)p[2], p[3]);
                }
            }
        }
        catch (Exception e) {
            isException = true;
            result = e;
        }
        JMXMessageReader.respond(context, request, result, isException);
    }

    private static void checkRequestAuthorization(JMXContext context, JMXRequest request) throws Exception {
        JMXAuthorizationChecker checker = context.getChannels().getAuhtorizationChecker();
        if (checker == null) {
            return;
        }
        if (debugEnabled) {
            log.debug("checking autorization for request = {}, with context {}", (Object)request, (Object)context);
        }
        Object[] p = request.getParams();
        switch (request.getMessageType()) {
            case 16: {
                checker.checkInvoke((ObjectName)p[0], (String)p[1], (Object[])p[2], (String[])p[3]);
                break;
            }
            case 9: {
                checker.checkGetAttribute((ObjectName)p[0], (String)p[1]);
                break;
            }
            case 10: {
                checker.checkGetAttributes((ObjectName)p[0], (String[])p[1]);
                break;
            }
            case 25: {
                checker.checkSetAttribute((ObjectName)p[0], (Attribute)p[1]);
                break;
            }
            case 26: {
                checker.checkSetAttributes((ObjectName)p[0], (AttributeList)p[1]);
                break;
            }
            case 5: {
                checker.checkCreateMBean((String)p[0], (ObjectName)p[1]);
                break;
            }
            case 6: {
                checker.checkCreateMBean((String)p[0], (ObjectName)p[1], (Object[])p[2], (String[])p[3]);
                break;
            }
            case 7: {
                checker.checkCreateMBean((String)p[0], (ObjectName)p[1], (ObjectName)p[2]);
                break;
            }
            case 8: {
                checker.checkCreateMBean((String)p[0], (ObjectName)p[1], (ObjectName)p[2], (Object[])p[3], (String[])p[4]);
                break;
            }
            case 11: {
                checker.checkGetDefaultDomain();
                break;
            }
            case 12: {
                checker.checkGetDomains();
                break;
            }
            case 13: {
                checker.checkGetMBeanCount();
                break;
            }
            case 14: {
                checker.checkGetMBeanInfo((ObjectName)p[0]);
                break;
            }
            case 15: {
                checker.checkGetObjectInstance((ObjectName)p[0]);
                break;
            }
            case 17: {
                checker.checkIsInstanceOf((ObjectName)p[0], (String)p[1]);
                break;
            }
            case 18: {
                checker.checkIsRegistered((ObjectName)p[0]);
                break;
            }
            case 19: {
                checker.checkQueryMBeans((ObjectName)p[0], (QueryExp)p[1]);
                break;
            }
            case 20: {
                checker.checkQueryNames((ObjectName)p[0], (QueryExp)p[1]);
                break;
            }
            case 27: {
                checker.checkUnregisterMBean((ObjectName)p[0]);
                break;
            }
            case 3: {
                checker.checkAddNotificationListener((ObjectName)p[0], (NotificationListener)null, (NotificationFilter)p[2], (Object)null);
                break;
            }
            case 4: {
                checker.checkAddNotificationListener((ObjectName)p[0], (ObjectName)p[1], (NotificationFilter)p[2], p[3]);
                break;
            }
            case 21: {
                checker.checkRemoveNotificationListener((ObjectName)p[0], (NotificationListener)null);
                break;
            }
            case 22: {
                checker.checkRemoveNotificationListener((ObjectName)p[0], (NotificationListener)null, (NotificationFilter)null, (Object)null);
                break;
            }
            case 23: {
                checker.checkRemoveNotificationListener((ObjectName)p[0], (ObjectName)p[1]);
                break;
            }
            case 24: {
                checker.checkRemoveNotificationListener((ObjectName)p[0], (ObjectName)p[1], (NotificationFilter)p[2], p[3]);
            }
        }
    }

    private static String handleConnect(JMXContext context, JMXRequest request) throws Exception {
        JMXAuthenticator authenticator = context.getChannels().getAuthenticator();
        if (authenticator != null) {
            Subject subject = authenticator.authenticate(request.getParams()[0]);
            context.getChannels().setSubject(subject);
            JMXAuthorizationChecker checker = context.getChannels().getAuhtorizationChecker();
            if (checker != null) {
                checker.setSubject(subject);
            }
        }
        return context.getConnectionID();
    }

    private static void handleClose(JMXContext context) throws Exception {
        context.getChannels().requestClose();
        context.getChannels().close(null);
        context.getServer().closeConnection(context.getChannels(), null, true);
    }

    private static void handleResponse(JMXContext context, JMXResponse response) throws Exception {
        context.getMessageHandler().responseReceived(response);
    }

    private static void handleNotification(JMXContext context, JMXNotification jmxNotification) throws Exception {
        if (debugEnabled) {
            log.debug("received notification {} from context = {}", (Object)jmxNotification, (Object)context);
        }
        context.getChannels().getJMXConnector().handleNotification(jmxNotification);
    }

    private static void respond(JMXContext context, JMXRequest request, Object result, boolean isException) throws Exception {
        if (request.getMessageType() == 2) {
            if (isException) {
                throw (Exception)result;
            }
        } else {
            JMXResponse response = new JMXResponse(request.getMessageID(), request.getMessageType(), result, isException);
            context.getMessageHandler().sendMessage(response);
        }
    }

    private static final class HandlingTask
    implements Runnable {
        private final JMXContext context;
        private final SimpleNioMessage message;

        private HandlingTask(JMXContext context, SimpleNioMessage message) {
            this.context = context;
            this.message = message;
        }

        @Override
        public void run() {
            try {
                JMXMessageReader.handleMessage(this.context, this.message);
            }
            catch (Error | Exception e) {
                block8: {
                    try {
                        if (debugEnabled) {
                            log.debug("error on channel {} :\n{}", (Object)this.context, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                        } else {
                            log.warn("error on channel {} : {}", (Object)this.context, (Object)ExceptionUtils.getMessage((Throwable)e));
                        }
                    }
                    catch (Exception e2) {
                        if (debugEnabled) {
                            log.debug("error on channel: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e2));
                            break block8;
                        }
                        log.warn("error on channel: {}", (Object)ExceptionUtils.getMessage((Throwable)e2));
                    }
                }
                if (e instanceof Exception) {
                    this.context.handleException((Exception)e);
                }
                throw (Error)e;
            }
        }
    }
}

