/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.jmxremote.nio;

import java.nio.channels.SelectionKey;
import org.jppf.jmxremote.nio.JMXContext;
import org.jppf.jmxremote.nio.JMXMessageWriter;
import org.jppf.jmxremote.nio.JMXNioServer;
import org.jppf.nio.StatelessNioServer;
import org.jppf.utils.ComparisonOperator;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.Operator;
import org.jppf.utils.concurrent.SynchronizedInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXTransitionTask
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(JMXTransitionTask.class);
    private static boolean debugEnabled = LoggingUtils.isDebugEnabled((Logger)log);
    private static boolean traceEnabled = log.isTraceEnabled();
    private final JMXContext context;
    private final JMXNioServer server;
    private final SynchronizedInteger requestCount = new SynchronizedInteger();
    private final boolean selecting;

    public JMXTransitionTask(JMXContext channel, JMXNioServer server, boolean selecting) {
        this.context = channel;
        this.server = server;
        this.selecting = selecting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.requestCount.compareAndSet(0, 1)) {
            return;
        }
        try {
            try {
                if (traceEnabled) {
                    log.trace("writing to channel {}", (Object)this.context);
                }
                boolean result = false;
                JMXContext jMXContext = this.context;
                synchronized (jMXContext) {
                    while (this.requestCount.get() > 0) {
                        try {
                            result = JMXMessageWriter.write(this.context);
                        }
                        finally {
                            this.requestCount.decrementAndGet();
                        }
                    }
                }
                if (result) {
                    if (this.selecting) {
                        this.server.updateInterestOps(this.context.getSelectionKey(), 4, true);
                    } else {
                        StatelessNioServer.updateInterestOpsNoWakeup((SelectionKey)this.context.getSelectionKey(), (int)4, (boolean)true);
                    }
                }
            }
            catch (Error | Exception e) {
                this.context.setEnabled(false);
                throw e;
            }
        }
        catch (Error | Exception e) {
            block23: {
                try {
                    if (debugEnabled) {
                        log.debug("error on channel {} :\n{}", (Object)this.context, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                    } else {
                        log.warn("error on channel {} : {}", (Object)this.context, (Object)ExceptionUtils.getMessage((Throwable)e));
                    }
                }
                catch (Exception e2) {
                    if (debugEnabled) {
                        log.debug("error on channel: {}", (Object)ExceptionUtils.getStackTrace((Throwable)e2));
                        break block23;
                    }
                    log.warn("error on channel: {}", (Object)ExceptionUtils.getMessage((Throwable)e2));
                }
            }
            if (e instanceof Exception) {
                this.context.handleException((Exception)e);
            }
            throw (Error)e;
        }
    }

    public boolean incrementCountIfNeeded() {
        return this.requestCount.compareAndIncrement((ComparisonOperator)Operator.MORE_THAN, 0);
    }
}

