/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.jmxremote.message;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jppf.JPPFTimeoutException;
import org.jppf.jmx.JMXEnvHelper;
import org.jppf.jmxremote.message.JMXMessage;
import org.jppf.jmxremote.message.JMXRequest;
import org.jppf.jmxremote.message.JMXResponse;
import org.jppf.jmxremote.nio.ChannelsPair;
import org.jppf.jmxremote.nio.JMXNioServer;
import org.jppf.jmxremote.nio.JMXTransitionTask;
import org.jppf.nio.StateTransitionManager;
import org.jppf.utils.EmptyEnum;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.LoggingUtils;
import org.jppf.utils.TypedProperties;
import org.jppf.utils.configuration.JPPFProperties;
import org.jppf.utils.configuration.JPPFProperty;
import org.slf4j.Logger;

public class JMXMessageHandler {
    private static final Logger log = LoggingUtils.getLogger(JMXMessageHandler.class, (boolean)JMXEnvHelper.isAsyncLoggingEnabled());
    private static final boolean debugEnabled = log.isDebugEnabled();
    public static final long CONNECTION_MESSAGE_ID = -1L;
    private static final AtomicLong messageSequence = new AtomicLong(0L);
    private final ChannelsPair channels;
    private final HashMap<Long, JMXRequest> requestMap = new HashMap();
    private final long requestTimeout;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final JMXNioServer server;
    private final StateTransitionManager<EmptyEnum, EmptyEnum> mgr;

    public JMXMessageHandler(ChannelsPair channels, Map<String, ?> env) {
        this.channels = channels;
        channels.setMessageHandler(this);
        this.server = channels.readingContext().getServer();
        this.mgr = this.server.getTransitionManager();
        this.requestTimeout = JMXEnvHelper.getLong((JPPFProperty)JPPFProperties.JMX_REMOTE_REQUEST_TIMEOUT, env, (TypedProperties)JPPFConfiguration.getProperties());
    }

    public ChannelsPair getChannels() {
        return this.channels;
    }

    public Object sendRequestWithResponse(byte type, Object ... params) throws Exception {
        return this.receiveResponse(new JMXRequest(type == 1 ? -1L : messageSequence.incrementAndGet(), type, params), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object receiveResponse(JMXRequest request, boolean doSendMessage) throws Exception {
        if (this.closed.get()) {
            return null;
        }
        if (debugEnabled) {
            log.debug("sending request {}, channels={}", (Object)request, (Object)this.channels);
        }
        this.putRequest(request);
        JMXRequest jMXRequest = request;
        synchronized (jMXRequest) {
            if (doSendMessage) {
                this.sendMessage(request);
            }
            this.waitForMessage(request);
        }
        JMXResponse response = request.getResponse();
        if (response != null) {
            if (debugEnabled) {
                log.debug("got response {}", (Object)response);
            }
            if (response.getException() != null) {
                throw response.getException();
            }
            return response.getResult();
        }
        throw new IOException("could not obtain a response to request " + request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseReceived(JMXResponse response) {
        JMXRequest request;
        if (debugEnabled) {
            log.debug("received response {}, channels={}", (Object)response, (Object)this.channels);
        }
        if ((request = this.removeRequest(response.getMessageID())) != null) {
            if (debugEnabled) {
                log.debug("found matching request {}", (Object)request);
            }
            JMXRequest jMXRequest = request;
            synchronized (jMXRequest) {
                request.setResponse(response);
                request.notify();
            }
        } else {
            log.warn("no matching request for {}, channels={}", (Object)response, (Object)this.channels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequestNoResponse(byte type, Object ... params) throws Exception {
        if (this.closed.get()) {
            return;
        }
        try {
            if (!this.channels.getSelectionKey().isValid()) {
                return;
            }
            JMXRequest request = new JMXRequest(messageSequence.incrementAndGet(), type, params);
            if (debugEnabled) {
                log.debug("sending request {}, channels={}", (Object)request, (Object)this.channels);
            }
            this.putRequest(request);
            JMXRequest jMXRequest = request;
            synchronized (jMXRequest) {
                this.sendMessage(request);
                this.waitForMessage(request);
            }
        }
        catch (JPPFTimeoutException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageSent(JMXMessage message) {
        JMXRequest request;
        if (debugEnabled) {
            log.debug("sent request {}, channels={}", (Object)message, (Object)this.channels);
        }
        if ((request = this.removeRequest(message.getMessageID())) == null) {
            log.warn("no matching request for {}", (Object)message);
        } else if (request != message) {
            log.warn("message and request do not match, request = {}, message = {}", (Object)request, (Object)message);
        }
        JMXMessage jMXMessage = message;
        synchronized (jMXMessage) {
            message.notify();
        }
    }

    public void sendMessage(JMXMessage message) throws Exception {
        if (this.closed.get()) {
            return;
        }
        if (debugEnabled) {
            log.debug("sending message {}", (Object)message);
        }
        this.channels.writingContext().offerJmxMessage(message);
        JMXTransitionTask task = this.channels.getWritingTask();
        if (!task.incrementCountIfNeeded()) {
            this.mgr.execute((Runnable)task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            HashMap<Long, JMXRequest> hashMap = this.requestMap;
            synchronized (hashMap) {
                for (Map.Entry<Long, JMXRequest> entry : this.requestMap.entrySet()) {
                    JMXRequest request;
                    JMXRequest jMXRequest = request = entry.getValue();
                    synchronized (jMXRequest) {
                        request.setResponse(new JMXResponse(request, null, false));
                        request.notify();
                    }
                }
                this.requestMap.clear();
            }
        }
    }

    private void waitForMessage(JMXRequest request) throws JPPFTimeoutException, Exception {
        long start = System.nanoTime();
        request.wait(this.requestTimeout);
        if ((System.nanoTime() - start) / 1000000L >= this.requestTimeout) {
            String text = "exceeded timeout of " + this.requestTimeout + " ms waiting for " + request + " on " + (Object)((Object)this.channels);
            log.warn(String.valueOf(text) + ", requests map = {}");
            throw new JPPFTimeoutException(text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putRequest(JMXRequest request) {
        HashMap<Long, JMXRequest> hashMap = this.requestMap;
        synchronized (hashMap) {
            this.requestMap.put(request.getMessageID(), request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMXRequest removeRequest(Long requestID) {
        HashMap<Long, JMXRequest> hashMap = this.requestMap;
        synchronized (hashMap) {
            return this.requestMap.remove(requestID);
        }
    }
}

