/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.jmxremote;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import org.jppf.jmxremote.JPPFJMXConnector;
import org.jppf.jmxremote.message.JMXMessageHandler;
import org.jppf.jmxremote.message.JMXNotification;
import org.jppf.jmxremote.nio.ChannelsPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFMBeanServerConnection
implements MBeanServerConnection,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(JPPFMBeanServerConnection.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final JMXMessageHandler messageHandler;
    private final JPPFJMXConnector connector;

    public JPPFMBeanServerConnection(JPPFJMXConnector connector) {
        this.connector = connector;
        this.messageHandler = connector.getMessageHandler();
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        try {
            return (ObjectInstance)this.messageHandler.sendRequestWithResponse((byte)5, className, name);
        }
        catch (MBeanRegistrationException e) {
            throw e;
        }
        catch (IOException | InstanceAlreadyExistsException | MBeanException | NotCompliantMBeanException | ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        try {
            return (ObjectInstance)this.messageHandler.sendRequestWithResponse((byte)7, className, name, loaderName);
        }
        catch (MBeanRegistrationException e) {
            throw e;
        }
        catch (IOException | InstanceAlreadyExistsException | InstanceNotFoundException | MBeanException | NotCompliantMBeanException | ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
        try {
            return (ObjectInstance)this.messageHandler.sendRequestWithResponse((byte)6, className, name, params, signature);
        }
        catch (MBeanRegistrationException e) {
            throw e;
        }
        catch (IOException | InstanceAlreadyExistsException | MBeanException | NotCompliantMBeanException | ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
        try {
            return (ObjectInstance)this.messageHandler.sendRequestWithResponse((byte)8, className, name, loaderName);
        }
        catch (MBeanRegistrationException e) {
            throw e;
        }
        catch (IOException | InstanceAlreadyExistsException | InstanceNotFoundException | MBeanException | NotCompliantMBeanException | ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
        try {
            this.messageHandler.sendRequestWithResponse((byte)27, name);
        }
        catch (IOException | InstanceNotFoundException | MBeanRegistrationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
        try {
            return (ObjectInstance)this.messageHandler.sendRequestWithResponse((byte)15, name);
        }
        catch (IOException | InstanceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) throws IOException {
        try {
            return (Set)this.messageHandler.sendRequestWithResponse((byte)19, name, query);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws IOException {
        try {
            return (Set)this.messageHandler.sendRequestWithResponse((byte)20, name, query);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean isRegistered(ObjectName name) throws IOException {
        try {
            return (Boolean)this.messageHandler.sendRequestWithResponse((byte)18, name);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Integer getMBeanCount() throws IOException {
        try {
            return (Integer)this.messageHandler.sendRequestWithResponse((byte)13, new Object[0]);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        try {
            return this.messageHandler.sendRequestWithResponse((byte)9, name, attribute);
        }
        catch (IOException | AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        try {
            return (AttributeList)this.messageHandler.sendRequestWithResponse((byte)10, name, attributes);
        }
        catch (IOException | InstanceNotFoundException | ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        try {
            this.messageHandler.sendRequestWithResponse((byte)25, name, attribute);
        }
        catch (IOException | AttributeNotFoundException | InstanceNotFoundException | InvalidAttributeValueException | MBeanException | ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        try {
            return (AttributeList)this.messageHandler.sendRequestWithResponse((byte)26, name, attributes);
        }
        catch (IOException | InstanceNotFoundException | ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        try {
            return this.messageHandler.sendRequestWithResponse((byte)16, name, operationName, params, signature);
        }
        catch (IOException | InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getDefaultDomain() throws IOException {
        try {
            return (String)this.messageHandler.sendRequestWithResponse((byte)11, new Object[0]);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public String[] getDomains() throws IOException {
        try {
            return (String[])this.messageHandler.sendRequestWithResponse((byte)12, new Object[0]);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        try {
            this.connector.addNotificationListener(name, listener, filter, handback);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
        try {
            this.messageHandler.sendRequestWithResponse((byte)4, name, listener, filter, handback);
        }
        catch (IOException | InstanceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            this.connector.removeNotificationListener(name, listener);
        }
        catch (IOException | InstanceNotFoundException | ListenerNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            this.connector.removeNotificationListener(name, listener, filter, handback);
        }
        catch (IOException | InstanceNotFoundException | ListenerNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            this.messageHandler.sendRequestWithResponse((byte)23, name, listener);
        }
        catch (IOException | InstanceNotFoundException | ListenerNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        try {
            this.messageHandler.sendRequestWithResponse((byte)24, name, listener, filter, handback);
        }
        catch (IOException | InstanceNotFoundException | ListenerNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        try {
            return (MBeanInfo)this.messageHandler.sendRequestWithResponse((byte)14, name);
        }
        catch (IOException | InstanceNotFoundException | IntrospectionException | ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        try {
            return (Boolean)this.messageHandler.sendRequestWithResponse((byte)17, name, className);
        }
        catch (IOException | InstanceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        ChannelsPair channels = this.messageHandler.getChannels();
        if (channels.isClosing() || channels.isClosed()) {
            return;
        }
        try {
            if (debugEnabled) {
                log.debug("closing {}", (Object)channels);
            }
            channels.requestClose();
            try {
                SelectionKey key = channels.getSelectionKey();
                SocketChannel channel = (SocketChannel)key.channel();
                if (key.isValid() && channel.isConnected() && channel.isOpen()) {
                    this.messageHandler.sendRequestNoResponse((byte)2, new Object[0]);
                }
            }
            finally {
                channels.close(null);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public JMXMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void handleNotification(JMXNotification jmxNotification) throws Exception {
        this.connector.handleNotification(jmxNotification);
    }
}

