/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.jmxremote.nio;

import java.nio.channels.SocketChannel;
import org.jppf.jmx.JMXEnvHelper;
import org.jppf.jmxremote.message.JMXRequest;
import org.jppf.jmxremote.nio.JMXContext;
import org.jppf.jmxremote.nio.MessageWrapper;
import org.jppf.utils.LoggingUtils;
import org.slf4j.Logger;

public class JMXMessageWriter {
    private static final Logger log = LoggingUtils.getLogger(JMXMessageWriter.class, (boolean)JMXEnvHelper.isAsyncLoggingEnabled());
    private static final boolean debugEnabled = log.isDebugEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean write(JMXContext context) throws Exception {
        if (context.isSsl()) {
            SocketChannel socketChannel = context.getSocketChannel();
            synchronized (socketChannel) {
                return JMXMessageWriter.doWrite(context);
            }
        }
        return JMXMessageWriter.doWrite(context);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private static boolean doWrite(JMXContext context) throws Exception {
        MessageWrapper msg;
        while (true) {
            if (context.getChannels().isClosed()) {
                return false;
            }
            if (context.getCurrentMessageWrapper() == null) {
                msg = context.pollJmxMessage();
                if (msg == null) {
                    return false;
                }
                if (debugEnabled) {
                    log.debug("about to send message {} from context {}", (Object)msg, (Object)context);
                }
                context.setCurrentMessageWrapper(msg);
                context.setReadMessage(msg.nioMessage);
            }
            msg = context.getCurrentMessageWrapper();
            if (context.writeMessage()) {
                if (debugEnabled) {
                    log.debug("fully sent message {} from context {}", (Object)msg, (Object)context);
                }
                context.setReadMessage(null);
                context.setCurrentMessageWrapper(null);
                if (msg.jmxMessage.getMessageType() != 2) continue;
                if (debugEnabled) {
                    log.debug("handling CLOSE for context {}", (Object)context);
                }
                context.getMessageHandler().messageSent(msg.jmxMessage);
                return false;
            }
            if (context.readByteCount <= 0L) return true;
            continue;
            break;
        }
        catch (Exception e) {
            if (!(msg.jmxMessage instanceof JMXRequest)) throw e;
            context.getMessageHandler().messageSent(msg.jmxMessage);
            throw e;
        }
    }
}

