/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.api.exception;

public class JRebirthThreadException
extends Exception {
    private static final long serialVersionUID = 112036725331588469L;
    private final Type threadType;

    public JRebirthThreadException(Type threadType) {
        super("Current code must be executed into: " + JRebirthThreadException.getThreadName(threadType));
        this.threadType = threadType;
    }

    private static String getThreadName(Type threadType) {
        String threadName;
        switch (threadType) {
            case NOT_RUN_INTO_JAT: {
                threadName = "JavaFX Application Thread";
                break;
            }
            case NOT_RUN_INTO_JIT: {
                threadName = "JRebirth Internal Thread";
                break;
            }
            case NOT_RUN_INTO_JTP: {
                threadName = "JRebirth Thread Pool";
                break;
            }
            default: {
                threadName = "";
            }
        }
        return threadName;
    }

    Type getThreadType() {
        return this.threadType;
    }

    public static enum Type {
        NOT_RUN_INTO_JAT,
        NOT_RUN_INTO_JIT,
        NOT_RUN_INTO_JTP;

    }
}

