/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.component.ui.stack;

import javafx.scene.layout.StackPane;
import org.jrebirth.af.component.ui.stack.PageEnum;
import org.jrebirth.af.component.ui.stack.StackView;
import org.jrebirth.af.component.ui.stack.StackWaves;
import org.jrebirth.af.core.command.basic.showmodel.DisplayModelWaveBean;
import org.jrebirth.af.core.command.basic.showmodel.ShowFadingModelCommand;
import org.jrebirth.af.core.key.UniqueKey;
import org.jrebirth.af.core.ui.DefaultModel;
import org.jrebirth.af.core.ui.Model;
import org.jrebirth.af.core.wave.Wave;
import org.jrebirth.af.core.wave.WaveBean;
import org.jrebirth.af.core.wave.WaveType;
import org.jrebirth.af.core.wave.checker.ClassWaveChecker;
import org.jrebirth.af.core.wave.checker.DefaultWaveChecker;
import org.jrebirth.af.core.wave.checker.WaveChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackModel
extends DefaultModel<StackModel, StackView> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StackModel.class);
    private UniqueKey<? extends Model> currentModelKey;
    private UniqueKey<? extends Model> defaultPageModelKey;

    protected void initModel() {
        this.listen((WaveChecker)new DefaultWaveChecker(StackWaves.STACK_NAME, (Object)this.getStackName()), new WaveType[]{StackWaves.SHOW_PAGE_MODEL});
        this.listen((WaveChecker)new ClassWaveChecker(StackWaves.PAGE_ENUM, this.getPageEnumClass()), new WaveType[]{StackWaves.SHOW_PAGE_ENUM});
    }

    public void doShowPageModel(UniqueKey<? extends Model> pageModelKey, String stackName, Wave wave) {
        if (this.getStackName() != null && this.getStackName().equals(stackName)) {
            this.showPage(pageModelKey);
        }
    }

    public void doShowPageEnum(PageEnum pageEnum, Wave wave) {
        LOGGER.info("Show Page Enum: " + pageEnum.toString());
        if (this.getPageEnumClass() != null && this.getPageEnumClass().equals(pageEnum.getClass())) {
            this.showPage(pageEnum.getModelKey());
        }
    }

    private Class<PageEnum> getPageEnumClass() {
        Class res = null;
        if (this.getFirstKeyPart() instanceof Class && PageEnum.class.isAssignableFrom((Class)this.getFirstKeyPart())) {
            res = (Class)this.getFirstKeyPart();
        }
        return res;
    }

    private String getStackName() {
        String res = null;
        if (this.getFirstKeyPart() instanceof String) {
            res = (String)this.getFirstKeyPart();
        }
        return res;
    }

    private void showPage(UniqueKey<? extends Model> pageModelKey) {
        LOGGER.info("Show Page Model: " + pageModelKey.toString());
        DisplayModelWaveBean waveBean = new DisplayModelWaveBean();
        waveBean.setChidrenPlaceHolder(((StackPane)((StackView)this.getView()).getRootNode()).getChildren());
        waveBean.setAppendChild(false);
        waveBean.setShowModelKey(pageModelKey);
        waveBean.setHideModelKey(this.currentModelKey);
        this.currentModelKey = waveBean.getShowModelKey();
        this.callCommand(ShowFadingModelCommand.class, (WaveBean)waveBean);
    }

    protected void showView() {
        if (this.currentModelKey == null) {
            if (this.getPageEnumClass() != null && this.getPageEnumClass().isEnum() && this.getPageEnumClass().getEnumConstants().length > 0) {
                this.doShowPageEnum(this.getPageEnumClass().getEnumConstants()[0], null);
            }
            if (this.getDefaultPageModelKey() != null) {
                this.doShowPageModel(this.getDefaultPageModelKey(), this.getStackName(), null);
            }
        }
    }

    public UniqueKey<? extends Model> getDefaultPageModelKey() {
        return this.defaultPageModelKey;
    }
}

