/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.component.behavior.swipable.data;

import java.io.Serializable;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.input.SwipeEvent;
import org.jrebirth.af.api.component.behavior.annotation.BehaviorDataFor;
import org.jrebirth.af.api.key.UniqueKey;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.component.behavior.swipable.SwipableBehavior;
import org.jrebirth.af.core.component.behavior.BehaviorDataBase;

@BehaviorDataFor(value=SwipableBehavior.class)
public class Swipable
extends BehaviorDataBase
implements Serializable {
    private static final long serialVersionUID = 8137109665415403740L;
    private UniqueKey<Model> modelKey;
    private Node node;
    private int touchCount = 1;
    private SwipableKind swipableKind = SwipableKind.Right;
    private EventType<SwipeEvent> redo = SwipeEvent.SWIPE_LEFT;
    private EventType<SwipeEvent> undo = SwipeEvent.SWIPE_RIGHT;

    public static Swipable create() {
        return new Swipable();
    }

    public UniqueKey<Model> modelKey() {
        return this.modelKey;
    }

    public Swipable modelKey(UniqueKey<Model> modelKey) {
        this.modelKey = modelKey;
        return this;
    }

    public Node node() {
        return this.node;
    }

    public Swipable node(Node node) {
        this.node = node;
        return this;
    }

    public int touchCount() {
        return this.touchCount;
    }

    public Swipable touchCount(int touchCount) {
        this.touchCount = touchCount;
        return this;
    }

    public SwipableKind swipableKind() {
        return this.swipableKind;
    }

    public Swipable swipableKind(SwipableKind swipableKind) {
        this.swipableKind = swipableKind;
        this.initEventTypes();
        return this;
    }

    private void initEventTypes() {
        switch (this.swipableKind()) {
            case Left: {
                this.redo((EventType<SwipeEvent>)SwipeEvent.SWIPE_RIGHT);
                this.redo((EventType<SwipeEvent>)SwipeEvent.SWIPE_LEFT);
                break;
            }
            case Top: {
                this.redo((EventType<SwipeEvent>)SwipeEvent.SWIPE_DOWN);
                this.redo((EventType<SwipeEvent>)SwipeEvent.SWIPE_UP);
                break;
            }
            case Right: {
                this.redo((EventType<SwipeEvent>)SwipeEvent.SWIPE_LEFT);
                this.redo((EventType<SwipeEvent>)SwipeEvent.SWIPE_RIGHT);
                break;
            }
            case Bottom: {
                this.redo((EventType<SwipeEvent>)SwipeEvent.SWIPE_UP);
                this.redo((EventType<SwipeEvent>)SwipeEvent.SWIPE_DOWN);
                break;
            }
        }
    }

    public EventType<SwipeEvent> redo() {
        return this.redo;
    }

    public Swipable redo(EventType<SwipeEvent> redo) {
        this.redo = redo;
        return this;
    }

    public EventType<SwipeEvent> undo() {
        return this.undo;
    }

    public Swipable undo(EventType<SwipeEvent> undo) {
        this.undo = undo;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" [");
        sb.append(this.node).append(", ");
        sb.append(this.touchCount);
        sb.append("]");
        return sb.toString();
    }

    public static enum SwipableKind {
        Custom,
        Left,
        Top,
        Right,
        Bottom;

    }
}

