/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.component.ui.dock;

import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import org.jrebirth.af.api.ui.object.ModelObject;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.checker.WaveChecker;
import org.jrebirth.af.api.wave.contract.WaveItem;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.component.ui.beans.DockConfig;
import org.jrebirth.af.component.ui.beans.DockOrientation;
import org.jrebirth.af.component.ui.beans.TabConfig;
import org.jrebirth.af.component.ui.dock.DockView;
import org.jrebirth.af.core.ui.object.DefaultObjectModel;
import org.jrebirth.af.core.util.ObjectUtility;
import org.jrebirth.af.core.wave.Builders;
import org.jrebirth.af.core.wave.WaveItemBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockModel
extends DefaultObjectModel<DockModel, DockView, DockConfig> {
    public static WaveItemBase<String> DOCK_KEY = new WaveItemBase<String>(false){};
    public static WaveItemBase<TabConfig> MODEL = new WaveItemBase<TabConfig>(){};
    public static WaveType ADD = Builders.waveType((String)"ADD_CONTAINER").items(new WaveItem[]{MODEL});
    public static WaveType REMOVE = Builders.waveType((String)"REMOVE_CONTAINER").items(new WaveItem[]{MODEL});
    private static final Logger LOGGER = LoggerFactory.getLogger(DockModel.class);
    private static int DOCK_COUNTER = 0;

    protected void initModel() {
        WaveChecker waveChecker = wave -> ObjectUtility.equalsOrBothNull((Object)wave.get(DOCK_KEY), (Object)((DockConfig)this.getObject()).dockKey());
        this.listen(waveChecker, new WaveType[]{ADD});
        this.listen(waveChecker, new WaveType[]{REMOVE});
        if (ObjectUtility.nullOrEmpty((String)((DockConfig)this.getObject()).dockKey())) {
            ((DockConfig)this.getObject()).dockKey(DockModel.class.getSimpleName() + DOCK_COUNTER++);
        }
    }

    protected void bind() {
        ((DockConfig)this.getObject()).orientationPy().addListener(this::onOrientationChanged);
        ((DockConfig)this.getObject()).panes().addListener(this::onPanesChanged);
    }

    private void onOrientationChanged(ObservableValue<? extends DockOrientation> property, DockOrientation oldValue, DockOrientation newValue) {
    }

    private void onPanesChanged(ListChangeListener.Change<? extends TabConfig> change) {
        while (change.next()) {
            System.out.println(change);
            if (change.wasPermutated()) {
                System.err.println("PERMUTATION -------------------------------------------------------------------");
            }
            if (change.wasRemoved()) {
                Platform.runLater(() -> ((DockView)this.getView()).removeContainer(change.getRemoved()));
            }
            if (!change.wasAdded()) continue;
            Platform.runLater(() -> ((DockView)this.getView()).addContainer(change.getFrom(), (TabConfig)change.getList().get(change.getFrom())));
        }
    }

    protected void showView() {
    }

    public void addContainer(ModelObject<TabConfig> model, Wave wave) {
        this.insertContainer(-1, model, wave);
    }

    public void removeContainer(ModelObject<TabConfig> model, Wave wave) {
    }

    public void insertContainer(int idx, ModelObject<TabConfig> model, Wave wave) {
        TabConfig t = (TabConfig)model.getObject();
        if (idx < 0) {
            idx = ((DockConfig)this.getObject()).panes().isEmpty() ? 0 : ((DockConfig)this.getObject()).panes().size();
        }
        ((DockConfig)this.getObject()).panes().add(idx, (Object)t);
    }
}

