/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.component.ui.tab;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.ScaleTransition;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.ui.annotation.RootNodeClass;
import org.jrebirth.af.component.behavior.dockable.DockableBehavior;
import org.jrebirth.af.component.behavior.dockable.data.Dockable;
import org.jrebirth.af.component.ui.beans.TabConfig;
import org.jrebirth.af.component.ui.beans.TabOrientation;
import org.jrebirth.af.component.ui.tab.TabController;
import org.jrebirth.af.component.ui.tab.TabModel;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.ui.DefaultView;

@RootNodeClass(value={"TabPanel"})
public class TabView
extends DefaultView<TabModel, BorderPane, TabController> {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(TabView.class);
    private StackPane stackPane;
    private final Map<String, Button> buttonByTab = new HashMap<String, Button>();
    private Rectangle marker;
    private Pane box;
    private Node hoverNode;

    public TabView(TabModel model) throws CoreException {
        super((Model)model);
    }

    protected void initView() {
        this.initButtonBar();
        this.stackPane = new StackPane();
        ((BorderPane)this.getRootNode()).setCenter((Node)this.stackPane);
    }

    private void initButtonBar() {
        switch (((TabConfig)((TabModel)this.getModel()).getObject()).orientation()) {
            case top: {
                ((BorderPane)this.getRootNode()).setTop((Node)this.buildButtonBar(true));
                break;
            }
            case bottom: {
                ((BorderPane)this.getRootNode()).setBottom((Node)this.buildButtonBar(true));
                break;
            }
            case left: {
                ((BorderPane)this.getRootNode()).setLeft((Node)this.buildButtonBar(false));
                break;
            }
            case right: {
                ((BorderPane)this.getRootNode()).setRight((Node)this.buildButtonBar(false));
            }
        }
    }

    void reloadButtonBar() {
        ((BorderPane)this.getRootNode()).setTop(null);
        ((BorderPane)this.getRootNode()).setBottom(null);
        ((BorderPane)this.getRootNode()).setLeft(null);
        ((BorderPane)this.getRootNode()).setRight(null);
        this.initButtonBar();
    }

    private Pane buildButtonBar(boolean isHorizontal) {
        if (isHorizontal) {
            this.box = new HBox();
            this.box.setMaxWidth(-1.0);
            this.box.getStyleClass().add((Object)"HorizontalTabbedContainer");
        } else {
            this.box = new VBox();
            this.box.setMaxHeight(-1.0);
            this.box.getStyleClass().add((Object)"VerticalTabbedContainer");
        }
        return this.box;
    }

    public void addTab(int idx, Dockable tab) {
        Button b = new Button(tab.name(), (Node)new ImageView(((DockableBehavior)((TabModel)this.getModel()).getBehavior(DockableBehavior.class)).modelIcon()));
        b.setUserData((Object)tab);
        this.buttonByTab.put(tab.name(), b);
        this.selectTab(tab);
        ((TabController)this.getController()).initTabEventHandler(b);
        if (idx < 0) {
            idx = this.box.getChildren().size();
        }
        b.setScaleX(0.0);
        this.box.getChildren().add(idx, (Object)b);
        ScaleTransition st = new ScaleTransition(Duration.millis((double)600.0));
        st.setNode((Node)b);
        st.setFromX(0.0);
        st.setToX(1.0);
        st.play();
    }

    public void removeTab(List<Dockable> tabs) {
        for (Dockable tab : tabs) {
            Button b = this.buttonByTab.get(tab.name());
            ScaleTransition st = new ScaleTransition(Duration.millis((double)600.0));
            st.setNode((Node)b);
            st.setFromX(1.0);
            st.setToX(0.0);
            st.setOnFinished(event -> this.box.getChildren().remove((Object)b));
            st.play();
        }
    }

    void selectTab(Dockable t) {
        this.stackPane.getChildren().clear();
        this.stackPane.getChildren().add((Object)((TabModel)this.getModel()).getModel(t.modelKey()).getRootNode());
    }

    Pane getBox() {
        return this.box;
    }

    public Button getButtonByTab(Dockable t) {
        return this.buttonByTab.get(t.name());
    }

    public void drawMarker(Button dragged, double x, double y) {
        int draggedIdx = this.getBox().getChildren().indexOf((Object)dragged);
        int markerIdx = this.getBox().getChildren().indexOf((Object)this.marker);
        int idx = 0;
        Node tempHoverNode = null;
        boolean xx = false;
        for (Node n : this.getBox().getChildren()) {
            if (n.getBoundsInParent().contains(x, y)) {
                tempHoverNode = n;
                break;
            }
            if (n == this.marker) continue;
            ++idx;
        }
        if (tempHoverNode == this.hoverNode) {
            return;
        }
        this.hoverNode = tempHoverNode;
        System.out.println("marker" + markerIdx + "  idx " + idx);
        if (markerIdx != idx) {
            if (this.marker != null) {
                this.getBox().getChildren().remove((Object)this.marker);
            }
            if (draggedIdx != idx) {
                this.marker = ((TabConfig)((TabModel)this.getModel()).getObject()).orientation() == TabOrientation.bottom || ((TabConfig)((TabModel)this.getModel()).getObject()).orientation() == TabOrientation.top ? new Rectangle(10.0, this.getBox().getHeight()) : new Rectangle(this.getBox().getWidth(), 4.0);
                this.marker.setFill((Paint)Color.LIGHTGREEN);
                this.getBox().getChildren().add(idx, (Object)this.marker);
            }
        }
    }

    public int removeMarker() {
        System.out.println("Remove Marker");
        int idx = this.getBox().getChildren().indexOf((Object)this.marker);
        this.getBox().getChildren().remove((Object)this.marker);
        return idx;
    }
}

