/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.component.ui.dock;

import javafx.scene.control.SplitPane;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.jrebirth.af.api.ui.object.ModelObject;
import org.jrebirth.af.component.behavior.dockable.data.Dockable;
import org.jrebirth.af.component.ui.CustomDataFormat;
import org.jrebirth.af.component.ui.beans.TabConfig;
import org.jrebirth.af.component.ui.beans.TabOrientation;
import org.jrebirth.af.component.ui.dock.DockController;
import org.jrebirth.af.component.ui.dock.DockModel;
import org.jrebirth.af.component.ui.dock.DockView;
import org.jrebirth.af.component.ui.tab.TabModel;
import org.jrebirth.af.core.ui.adapter.AbstractDefaultAdapter;
import org.jrebirth.af.core.ui.adapter.DragAdapter;

public class DockTargetDragAdapter
extends AbstractDefaultAdapter<DockController>
implements DragAdapter {
    public void dragOver(DragEvent dragEvent) {
        if (dragEvent.getDragboard().hasContent(CustomDataFormat.DOCKABLE)) {
            dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
        }
        dragEvent.consume();
    }

    public void dragEnteredTarget(DragEvent dragEvent) {
    }

    public void dragEntered(DragEvent dragEvent) {
        if (dragEvent.getDragboard().hasContent(CustomDataFormat.DOCKABLE)) {
            ((SplitPane)((DockView)((DockController)this.getController()).getView()).getRootNode()).setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.AQUAMARINE, BorderStrokeStyle.SOLID, new CornerRadii(1.0), BorderStroke.THICK)}));
        }
        dragEvent.consume();
    }

    public void dragExited(DragEvent dragEvent) {
        if (dragEvent.getDragboard().hasContent(CustomDataFormat.DOCKABLE)) {
            ((SplitPane)((DockView)((DockController)this.getController()).getView()).getRootNode()).setBorder(null);
        }
        dragEvent.consume();
    }

    public void dragExitedTarget(DragEvent dragEvent) {
    }

    public void dragDropped(DragEvent dragEvent) {
        Dragboard db = dragEvent.getDragboard();
        boolean success = false;
        if (db.hasContent(CustomDataFormat.DOCKABLE)) {
            Dockable serializedTab = (Dockable)db.getContent(CustomDataFormat.DOCKABLE);
            TabModel model = (TabModel)((DockModel)((DockController)this.getController()).getModel()).getModel(TabModel.class, new Object[]{TabConfig.create().tabKey("ddddd").orientation(TabOrientation.top)});
            ((DockModel)((DockController)this.getController()).getModel()).addContainer((ModelObject<TabConfig>)model, null);
            success = true;
        }
        dragEvent.setDropCompleted(success);
        dragEvent.consume();
    }

    public void dragDone(DragEvent dragEvent) {
        dragEvent.consume();
    }
}

