/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.component.ui.dock;

import java.util.List;
import javafx.geometry.Orientation;
import javafx.scene.control.SplitPane;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.ui.annotation.RootNodeClass;
import org.jrebirth.af.component.ui.beans.DockConfig;
import org.jrebirth.af.component.ui.beans.TabConfig;
import org.jrebirth.af.component.ui.dock.DockController;
import org.jrebirth.af.component.ui.dock.DockModel;
import org.jrebirth.af.component.ui.tab.TabModel;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.ui.DefaultView;

@RootNodeClass(value={"DockPanel"})
public class DockView
extends DefaultView<DockModel, SplitPane, DockController> {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(DockView.class);

    public DockView(DockModel model) throws CoreException {
        super((Model)model);
    }

    protected void initView() {
        super.initView();
        switch (((DockConfig)((DockModel)this.getModel()).getObject()).orientation()) {
            case horizontal: {
                ((SplitPane)this.getRootNode()).setOrientation(Orientation.HORIZONTAL);
                break;
            }
            case vertical: {
                ((SplitPane)this.getRootNode()).setOrientation(Orientation.VERTICAL);
            }
        }
    }

    void removeContainer(List<TabConfig> removed) {
        for (TabConfig tabConfig : removed) {
            TabModel model = (TabModel)((DockModel)this.getModel()).getModel(TabModel.class, new Object[]{tabConfig});
            ((SplitPane)this.getRootNode()).getItems().remove((Object)model.getRootNode());
        }
    }

    void addContainer(int from, TabConfig tabConfig) {
        TabModel model = (TabModel)((DockModel)this.getModel()).getModel(TabModel.class, new Object[]{tabConfig});
        ((SplitPane)this.getRootNode()).getItems().add((Object)model.getRootNode());
    }
}

