/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.component.ui.tab;

import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.checker.WaveChecker;
import org.jrebirth.af.api.wave.contract.WaveItem;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.component.behavior.dockable.data.Dockable;
import org.jrebirth.af.component.ui.beans.TabConfig;
import org.jrebirth.af.component.ui.beans.TabOrientation;
import org.jrebirth.af.component.ui.tab.TabView;
import org.jrebirth.af.core.ui.object.DefaultObjectModel;
import org.jrebirth.af.core.util.ObjectUtility;
import org.jrebirth.af.core.wave.Builders;
import org.jrebirth.af.core.wave.WaveItemBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabModel
extends DefaultObjectModel<TabModel, TabView, TabConfig> {
    public static WaveItemBase<String> TAB_KEY = new WaveItemBase<String>(false){};
    public static WaveItemBase<Dockable> TAB = new WaveItemBase<Dockable>(){};
    public static WaveType ADD = Builders.waveType((String)"ADD_TAB").items(new WaveItem[]{TAB});
    public static WaveType REMOVE = Builders.waveType((String)"REMOVE_TAB").items(new WaveItem[]{TAB});
    private static final Logger LOGGER = LoggerFactory.getLogger(TabModel.class);
    private static int TAB_COUNTER = 0;

    protected void initModel() {
        WaveChecker waveChecker = wave -> ObjectUtility.equalsOrBothNull((Object)wave.get(TAB_KEY), (Object)((TabConfig)this.getObject()).tabKey());
        this.listen(waveChecker, new WaveType[]{ADD});
        this.listen(waveChecker, new WaveType[]{REMOVE});
        if (ObjectUtility.nullOrEmpty((String)((TabConfig)this.getObject()).tabKey())) {
            ((TabConfig)this.getObject()).tabKey(TabModel.class.getSimpleName() + TAB_COUNTER++);
        }
    }

    protected void bind() {
        ((TabConfig)this.getObject()).orientationPy().addListener(this::onOrientationChanged);
        ((TabConfig)this.getObject()).tabs().addListener(this::onTabsChanged);
    }

    private void onOrientationChanged(ObservableValue<? extends TabOrientation> property, TabOrientation oldValue, TabOrientation newValue) {
        ((TabView)this.getView()).reloadButtonBar();
        for (Dockable tab : ((TabConfig)this.getObject()).tabs()) {
            ((TabView)this.getView()).addTab(((TabConfig)this.getObject()).tabs().size(), tab);
        }
    }

    private void onTabsChanged(ListChangeListener.Change<? extends Dockable> change) {
        while (change.next()) {
            System.out.println(change);
            if (change.wasPermutated()) {
                System.err.println("PERMUTATION -------------------------------------------------------------------");
            }
            if (change.wasRemoved()) {
                Platform.runLater(() -> ((TabView)this.getView()).removeTab(change.getRemoved()));
            }
            if (!change.wasAdded()) continue;
            Platform.runLater(() -> ((TabView)this.getView()).addTab(change.getFrom(), (Dockable)change.getList().get(change.getFrom())));
        }
    }

    protected void showView() {
    }

    public void addTab(Dockable tab, Wave wave) {
        this.insertTab(-1, tab, wave);
    }

    public void removeTab(Dockable tab, Wave wave) {
    }

    public void insertTab(int idx, Dockable tab, Wave wave) {
        if (idx < 0) {
            idx = ((TabConfig)this.getObject()).tabs().isEmpty() ? 0 : ((TabConfig)this.getObject()).tabs().size();
        }
        ((TabConfig)this.getObject()).tabs().add(idx, (Object)tab);
    }
}

