/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.component.ui.tab;

import javafx.animation.ScaleTransition;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Pane;
import javafx.util.Duration;
import org.jrebirth.af.component.behavior.dockable.data.Dockable;
import org.jrebirth.af.component.ui.CustomDataFormat;
import org.jrebirth.af.component.ui.beans.TabConfig;
import org.jrebirth.af.component.ui.tab.TabController;
import org.jrebirth.af.component.ui.tab.TabModel;
import org.jrebirth.af.component.ui.tab.TabView;
import org.jrebirth.af.core.ui.adapter.AbstractDefaultAdapter;
import org.jrebirth.af.core.ui.adapter.DragAdapter;

class TabTargetDragAdapter
extends AbstractDefaultAdapter<TabController>
implements DragAdapter {
    TabTargetDragAdapter() {
    }

    public void dragOver(DragEvent dragEvent) {
        if (dragEvent.getGestureSource() != ((TabView)((TabController)this.getController()).getView()).getBox() && dragEvent.getDragboard().hasContent(CustomDataFormat.DOCKABLE)) {
            dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            ((TabView)((TabController)this.getController()).getView()).drawMarker((Button)dragEvent.getGestureSource(), dragEvent.getX(), dragEvent.getY());
            dragEvent.consume();
        }
    }

    public void dragEnteredTarget(DragEvent dragEvent) {
    }

    public void dragEntered(DragEvent dragEvent) {
        if (dragEvent.getGestureSource() == ((TabView)((TabController)this.getController()).getView()).getBox() || dragEvent.getDragboard().hasContent(CustomDataFormat.DOCKABLE)) {
            // empty if block
        }
        dragEvent.consume();
    }

    public void dragExited(DragEvent dragEvent) {
        if (dragEvent.getGestureSource() != ((TabView)((TabController)this.getController()).getView()).getBox() && dragEvent.getDragboard().hasContent(CustomDataFormat.DOCKABLE)) {
            ((TabView)((TabController)this.getController()).getView()).removeMarker();
        }
        dragEvent.consume();
    }

    public void dragExitedTarget(DragEvent dragEvent) {
    }

    public void dragDropped(DragEvent dragEvent) {
        Dragboard db = dragEvent.getDragboard();
        boolean success = false;
        if (db.hasContent(CustomDataFormat.DOCKABLE)) {
            Dockable serializedTab = (Dockable)db.getContent(CustomDataFormat.DOCKABLE);
            Button b = ((TabView)((TabController)this.getController()).getView()).getButtonByTab(serializedTab);
            Pane targetBox = ((TabView)((TabController)this.getController()).getView()).getBox();
            int idx = ((TabView)((TabController)this.getController()).getView()).removeMarker();
            System.out.println("Add tab " + serializedTab.name() + " at " + idx);
            if (targetBox.getChildren().contains((Object)b)) {
                Dockable realTab = (Dockable)b.getUserData();
                int currentIdx = targetBox.getChildren().indexOf((Object)b);
                if (currentIdx != idx) {
                    ((TabConfig)((TabModel)((TabController)this.getController()).getModel()).getObject()).tabs().remove((Object)realTab);
                    ((TabConfig)((TabModel)((TabController)this.getController()).getModel()).getObject()).tabs().add(idx, (Object)realTab);
                    b.fire();
                }
            } else {
                Node n = (Node)dragEvent.getGestureSource();
                ScaleTransition st = new ScaleTransition(Duration.millis((double)600.0));
                st.setNode(n);
                st.setFromX(1.0);
                st.setToX(0.0);
                st.setOnFinished(event -> ((Pane)n.getParent()).getChildren().remove((Object)n));
                st.play();
                ((TabModel)((TabController)this.getController()).getModel()).insertTab(idx, serializedTab, null);
            }
            success = true;
        }
        dragEvent.setDropCompleted(success);
        dragEvent.consume();
    }

    public void dragDone(DragEvent dragEvent) {
        dragEvent.consume();
    }
}

