/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.application;

import javafx.application.Application;
import javafx.application.Platform;
import org.jrebirth.af.core.application.AbstractApplication;
import org.jrebirth.af.core.application.DefaultApplication;
import org.jrebirth.af.core.application.JRebirthApplication;
import org.jrebirth.af.core.concurrent.JRebirthThread;
import org.junit.After;
import org.junit.Before;

public class ApplicationTest<A extends DefaultApplication<?>> {
    private final Class<A> appClass;
    private A application;

    public ApplicationTest(Class<A> appClass) {
        this.appClass = appClass;
    }

    @Before
    public void setUp() throws Exception {
        this.application = (DefaultApplication)ApplicationTest.launchApplication(this.appClass);
    }

    @After
    public void tearDown() throws Exception {
        ApplicationTest.closeApplication(this.application);
    }

    public static <APP extends AbstractApplication<?>> APP launchApplication(final Class<APP> applicationClass) {
        JRebirthApplication app;
        Thread launcherThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Application.launch((Class)applicationClass, (String[])new String[0]);
            }
        });
        launcherThread.start();
        do {
            app = JRebirthThread.getThread().getApplication();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (app == null);
        return (APP)((AbstractApplication)app);
    }

    public static void closeApplication(AbstractApplication<?> application) {
        JRebirthThread jit = JRebirthThread.getThread();
        Platform.setImplicitExit((boolean)true);
        Platform.exit();
        while (jit == JRebirthThread.getThread()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Closed");
    }
}

