/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.command.basic;

import javafx.application.Application;
import org.jrebirth.af.core.application.TestApplication;
import org.jrebirth.af.core.command.Command;
import org.jrebirth.af.core.concurrent.JRebirthThread;
import org.jrebirth.af.core.facade.GlobalFacadeBase;
import org.jrebirth.af.core.wave.DefaultWaveListener;
import org.jrebirth.af.core.wave.Wave;
import org.jrebirth.af.core.wave.WaveListener;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public class BasicCommandTest {
    private static GlobalFacadeBase globalFacade;
    private boolean wait = false;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Application.launch(TestApplication.class, (String[])new String[0]);
            }
        }).start();
        Thread.sleep(1000L);
        globalFacade = (GlobalFacadeBase)JRebirthThread.getThread().getFacade();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        globalFacade.stop();
        globalFacade = null;
    }

    public void runCommand(Class<? extends Command> commandClass) {
        this.wait = true;
        Wave wave = ((Command)globalFacade.getCommandFacade().retrieve(commandClass, new Object[0])).run();
        wave.addWaveListener((WaveListener)new DefaultWaveListener(){

            public void waveConsumed(Wave wave) {
                BasicCommandTest.this.wait = false;
            }
        });
        while (this.wait) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

